/*
 * Decompiled with CFR 0.152.
 */
package org.artifactory.aql.result.rows.populate;

import java.util.List;
import java.util.stream.Collectors;
import org.artifactory.aql.AqlException;
import org.artifactory.aql.model.AqlPhysicalFieldEnum;
import org.artifactory.aql.model.AqlRepoProvider;
import org.artifactory.aql.model.DomainSensitiveField;
import org.artifactory.aql.result.rows.RowResult;
import org.artifactory.aql.result.rows.populate.FieldResultPopulator;
import org.artifactory.aql.result.rows.populate.RowPopulationContext;
import org.artifactory.repo.RepoPath;
import org.artifactory.repo.RepoPathFactory;

public class ItemVirtualReposPopulator
implements FieldResultPopulator {
    @Override
    public void populate(RowPopulationContext populationContext, DomainSensitiveField field) {
        RowResult row = populationContext.getRow();
        String repo = (String)row.get(new DomainSensitiveField(AqlPhysicalFieldEnum.itemRepo, field.getSubDomains()));
        String path = (String)row.get(new DomainSensitiveField(AqlPhysicalFieldEnum.itemPath, field.getSubDomains()));
        String name = (String)row.get(new DomainSensitiveField(AqlPhysicalFieldEnum.itemName, field.getSubDomains()));
        if (repo != null && path != null && name != null) {
            RepoPath repoPath = RepoPathFactory.create((String)repo, (String)(path + "/" + name));
            String[] virtualRepoKeys = this.getVirtualRepoKeysForRepoPath(populationContext, repoPath);
            row.put(field, virtualRepoKeys);
        } else if (repo != null || path != null || name != null) {
            throw new AqlException("Unhandled field; item repo, path & name fields are required: " + field);
        }
    }

    private String[] getVirtualRepoKeysForRepoPath(RowPopulationContext populationContext, RepoPath repoPath) {
        String repoKey = repoPath.getRepoKey();
        AqlRepoProvider repoProvider = populationContext.getRepoProvider();
        List<String> virtualRepoKeys = populationContext.getVirtualRepoKeysContainingRepo(repoKey);
        List<String> filteredVirtualRepoKeys = virtualRepoKeys.stream().map(virtualRepoKey -> RepoPathFactory.create((String)virtualRepoKey, (String)repoPath.getPath())).filter(repoProvider::isRepoPathAccepted).map(RepoPath::getRepoKey).sorted().collect(Collectors.toList());
        return filteredVirtualRepoKeys.toArray(new String[filteredVirtualRepoKeys.size()]);
    }
}

