/*
 * Decompiled with CFR 0.152.
 */
package org.artifactory.aql.model;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.artifactory.aql.model.AqlFieldEnum;
import org.artifactory.aql.model.AqlLogicalFieldEnum;
import org.artifactory.aql.model.AqlPhysicalFieldEnum;
import org.artifactory.aql.util.AqlUtils;

public enum AqlDomainEnum {
    items("item", AqlUtils.arrayOf("items")),
    properties("property", AqlUtils.arrayOf("properties")),
    statistics("stat", AqlUtils.arrayOf("stats")),
    archives("archive", AqlUtils.arrayOf("archives")),
    entries("entry", AqlUtils.arrayOf("archive", "entries")),
    builds("build", AqlUtils.arrayOf("builds")),
    artifacts("artifact", AqlUtils.arrayOf("artifacts")),
    dependencies("dependency", AqlUtils.arrayOf("dependencies")),
    modules("module", AqlUtils.arrayOf("modules")),
    buildProperties("property", AqlUtils.arrayOf("build", "properties")),
    buildPromotions("promotion", AqlUtils.arrayOf("build", "promotions")),
    moduleProperties("property", AqlUtils.arrayOf("module", "properties")),
    releaseBundles("release", AqlUtils.arrayOf("releases")),
    releaseBundleFiles("release_artifact", AqlUtils.arrayOf("release_artifacts"));

    public final String signature;
    public final String[] subDomains;

    private AqlDomainEnum(String signature, String[] subDomains) {
        this.signature = signature;
        this.subDomains = subDomains;
    }

    public static AqlDomainEnum valueFromSubDomains(List<String> subDomains) {
        Object[] externalSubDomain = subDomains.toArray(new String[subDomains.size()]);
        for (AqlDomainEnum aqlDomainEnum : AqlDomainEnum.values()) {
            if (!Arrays.equals(aqlDomainEnum.subDomains, externalSubDomain)) continue;
            return aqlDomainEnum;
        }
        return null;
    }

    public AqlFieldEnum[] getDefaultResultFields() {
        List<AqlFieldEnum> fields = Stream.of(AqlPhysicalFieldEnum.getFieldsByDomain(this)).filter(AqlPhysicalFieldEnum::isDefaultResultField).collect(Collectors.toList());
        return fields.toArray(new AqlFieldEnum[fields.size()]);
    }

    public AqlPhysicalFieldEnum[] getPhysicalFields() {
        return AqlPhysicalFieldEnum.getFieldsByDomain(this);
    }

    public AqlLogicalFieldEnum[] getLogicalFields() {
        return AqlLogicalFieldEnum.getFieldsByDomain(this);
    }

    public AqlFieldEnum[] getAllFields() {
        List<AqlFieldEnum> fields = Stream.concat(Stream.of(this.getPhysicalFields()), Stream.of(this.getLogicalFields())).collect(Collectors.toList());
        return fields.toArray(new AqlFieldEnum[fields.size()]);
    }

    public AqlPhysicalFieldEnum resolvePhysicalField(String fieldSignature) {
        return Stream.of(this.getPhysicalFields()).filter(field -> field.getSignature().equals(fieldSignature)).findFirst().orElse(null);
    }

    public AqlFieldEnum resolveField(String fieldSignature) {
        return Stream.concat(Stream.of(this.getPhysicalFields()), Stream.of(this.getLogicalFields())).filter(field -> ((AqlFieldEnum)((Object)field)).getSignature().equals(fieldSignature)).findFirst().orElse(null);
    }
}

