/*
 * Decompiled with CFR 0.152.
 */
package org.artifactory.aql.api.internal;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.artifactory.aql.api.internal.AqlBase;
import org.artifactory.aql.model.AqlComparatorEnum;
import org.artifactory.aql.model.AqlDomainEnum;
import org.artifactory.aql.model.AqlFieldEnum;
import org.artifactory.aql.model.AqlLogicalFieldEnum;
import org.artifactory.aql.model.AqlPhysicalFieldEnum;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.ISODateTimeFormat;

public class AqlApiDynamicFieldsDomains {

    public static class AqlApiComparator<T extends AqlBase>
    extends AqlApiField<T> {
        private final AqlPhysicalFieldEnum fieldEnum;

        public AqlApiComparator(AqlPhysicalFieldEnum fieldEnum, List<AqlDomainEnum> domains) {
            super(fieldEnum, domains);
            this.fieldEnum = fieldEnum;
        }

        @Override
        public AqlPhysicalFieldEnum getFieldEnum() {
            return this.fieldEnum;
        }

        public AqlBase.CriteriaClause<T> matches(int value) {
            return new AqlBase.CriteriaClause(this.fieldEnum, this.domains, AqlComparatorEnum.matches, "" + value);
        }

        public AqlBase.CriteriaClause<T> matches(long value) {
            return new AqlBase.CriteriaClause(this.fieldEnum, this.domains, AqlComparatorEnum.matches, "" + value);
        }

        public AqlBase.CriteriaClause<T> matches(DateTime value) {
            String dateString = AqlApiComparator.convertDateToString(value);
            return new AqlBase.CriteriaClause(this.fieldEnum, this.domains, AqlComparatorEnum.matches, dateString);
        }

        public AqlBase.CriteriaClause<T> matches(String value) {
            return new AqlBase.CriteriaClause(this.fieldEnum, this.domains, AqlComparatorEnum.matches, value);
        }

        public AqlBase.CriteriaClause<T> notMatches(int value) {
            return new AqlBase.CriteriaClause(this.fieldEnum, this.domains, AqlComparatorEnum.notMatches, "" + value);
        }

        public AqlBase.CriteriaClause<T> notMatches(long value) {
            return new AqlBase.CriteriaClause(this.fieldEnum, this.domains, AqlComparatorEnum.notMatches, "" + value);
        }

        public AqlBase.CriteriaClause<T> notMatches(DateTime value) {
            String dateString = AqlApiComparator.convertDateToString(value);
            return new AqlBase.CriteriaClause(this.fieldEnum, this.domains, AqlComparatorEnum.notMatches, dateString);
        }

        public AqlBase.CriteriaClause<T> notMatches(String value) {
            return new AqlBase.CriteriaClause(this.fieldEnum, this.domains, AqlComparatorEnum.notMatches, value);
        }

        public AqlBase.CriteriaClause<T> equals(int value) {
            return new AqlBase.CriteriaClause(this.fieldEnum, this.domains, AqlComparatorEnum.equals, "" + value);
        }

        public AqlBase.CriteriaClause<T> equals(long value) {
            return new AqlBase.CriteriaClause(this.fieldEnum, this.domains, AqlComparatorEnum.equals, "" + value);
        }

        public AqlBase.CriteriaClause<T> equals(DateTime value) {
            String dateString = AqlApiComparator.convertDateToString(value);
            return new AqlBase.CriteriaClause(this.fieldEnum, this.domains, AqlComparatorEnum.equals, dateString);
        }

        public AqlBase.CriteriaClause<T> equal(String value) {
            return new AqlBase.CriteriaClause(this.fieldEnum, this.domains, AqlComparatorEnum.equals, value);
        }

        public AqlBase.CriteriaClause<T> notEquals(int value) {
            return new AqlBase.CriteriaClause(this.fieldEnum, this.domains, AqlComparatorEnum.notEquals, "" + value);
        }

        public AqlBase.CriteriaClause<T> notEquals(long value) {
            return new AqlBase.CriteriaClause(this.fieldEnum, this.domains, AqlComparatorEnum.notEquals, "" + value);
        }

        public AqlBase.CriteriaClause<T> notEquals(DateTime value) {
            String dateString = AqlApiComparator.convertDateToString(value);
            return new AqlBase.CriteriaClause(this.fieldEnum, this.domains, AqlComparatorEnum.notEquals, dateString);
        }

        public AqlBase.CriteriaClause<T> notEquals(String value) {
            return new AqlBase.CriteriaClause(this.fieldEnum, this.domains, AqlComparatorEnum.notEquals, value);
        }

        public AqlBase.CriteriaClause<T> greater(int value) {
            return new AqlBase.CriteriaClause(this.fieldEnum, this.domains, AqlComparatorEnum.greater, "" + value);
        }

        public AqlBase.CriteriaClause<T> greater(long value) {
            return new AqlBase.CriteriaClause(this.fieldEnum, this.domains, AqlComparatorEnum.greater, "" + value);
        }

        public AqlBase.CriteriaClause<T> greater(DateTime value) {
            String dateString = AqlApiComparator.convertDateToString(value);
            return new AqlBase.CriteriaClause(this.fieldEnum, this.domains, AqlComparatorEnum.greater, dateString);
        }

        public AqlBase.CriteriaClause<T> greater(String value) {
            return new AqlBase.CriteriaClause(this.fieldEnum, this.domains, AqlComparatorEnum.greater, value);
        }

        public AqlBase.CriteriaClause<T> greaterEquals(int value) {
            return new AqlBase.CriteriaClause(this.fieldEnum, this.domains, AqlComparatorEnum.greaterEquals, "" + value);
        }

        public AqlBase.CriteriaClause<T> greaterEquals(long value) {
            return new AqlBase.CriteriaClause(this.fieldEnum, this.domains, AqlComparatorEnum.greaterEquals, "" + value);
        }

        public AqlBase.CriteriaClause<T> greaterEquals(DateTime value) {
            String dateString = AqlApiComparator.convertDateToString(value);
            return new AqlBase.CriteriaClause(this.fieldEnum, this.domains, AqlComparatorEnum.greaterEquals, dateString);
        }

        public AqlBase.CriteriaClause<T> greaterEquals(String value) {
            return new AqlBase.CriteriaClause(this.fieldEnum, this.domains, AqlComparatorEnum.greaterEquals, value);
        }

        public AqlBase.CriteriaClause<T> less(int value) {
            return new AqlBase.CriteriaClause(this.fieldEnum, this.domains, AqlComparatorEnum.less, "" + value);
        }

        public AqlBase.CriteriaClause<T> less(long value) {
            return new AqlBase.CriteriaClause(this.fieldEnum, this.domains, AqlComparatorEnum.less, "" + value);
        }

        public AqlBase.CriteriaClause<T> less(DateTime value) {
            String dateString = AqlApiComparator.convertDateToString(value);
            return new AqlBase.CriteriaClause(this.fieldEnum, this.domains, AqlComparatorEnum.less, dateString);
        }

        public AqlBase.CriteriaClause<T> less(String value) {
            return new AqlBase.CriteriaClause(this.fieldEnum, this.domains, AqlComparatorEnum.less, value);
        }

        public AqlBase.CriteriaClause<T> lessEquals(int value) {
            return new AqlBase.CriteriaClause(this.fieldEnum, this.domains, AqlComparatorEnum.lessEquals, "" + value);
        }

        public AqlBase.CriteriaClause<T> lessEquals(long value) {
            return new AqlBase.CriteriaClause(this.fieldEnum, this.domains, AqlComparatorEnum.lessEquals, "" + value);
        }

        public AqlBase.CriteriaClause<T> lessEquals(DateTime value) {
            String dateString = AqlApiComparator.convertDateToString(value);
            return new AqlBase.CriteriaClause(this.fieldEnum, this.domains, AqlComparatorEnum.lessEquals, dateString);
        }

        public AqlBase.CriteriaClause<T> lessEquals(String value) {
            return new AqlBase.CriteriaClause(this.fieldEnum, this.domains, AqlComparatorEnum.lessEquals, value);
        }

        private static String convertDateToString(DateTime date) {
            if (date == null) {
                return null;
            }
            return ISODateTimeFormat.dateTime().print((ReadableInstant)date);
        }
    }

    public static class AqlApiField<T extends AqlBase> {
        protected final List<AqlDomainEnum> domains = Lists.newArrayList();
        private final AqlFieldEnum fieldEnum;

        public AqlApiField(AqlFieldEnum fieldEnum, List<AqlDomainEnum> domains) {
            this.fieldEnum = fieldEnum;
            this.domains.addAll(domains);
        }

        public AqlFieldEnum getFieldEnum() {
            return this.fieldEnum;
        }

        public List<AqlDomainEnum> getDomains() {
            return this.domains;
        }
    }

    public static class AqlApiReleaseBundleFileDynamicFieldsDomains<T extends AqlBase> {
        private final List<AqlDomainEnum> domains = Lists.newArrayList();

        public AqlApiReleaseBundleFileDynamicFieldsDomains(ArrayList<AqlDomainEnum> domains) {
            this.domains.addAll(domains);
        }

        public AqlApiComparator<T> id() {
            return new AqlApiComparator(AqlPhysicalFieldEnum.releaseBundleFileId, this.domains);
        }

        public AqlApiComparator<T> nodeId() {
            return new AqlApiComparator(AqlPhysicalFieldEnum.releaseBundleFileNodeId, this.domains);
        }

        public AqlApiComparator<T> bundleId() {
            return new AqlApiComparator(AqlPhysicalFieldEnum.releaseBundleFileBundleId, this.domains);
        }

        public AqlApiComparator<T> repoPath() {
            return new AqlApiComparator(AqlPhysicalFieldEnum.releaseBundleFileRepoPath, this.domains);
        }

        public AqlApiReleaseBundleDynamicFieldsDomains<T> release() {
            ArrayList tempDomains = Lists.newArrayList(this.domains);
            tempDomains.add(AqlDomainEnum.releaseBundles);
            return new AqlApiReleaseBundleDynamicFieldsDomains(tempDomains);
        }

        public AqlApiItemDynamicFieldsDomains<T> item() {
            ArrayList tempDomains = Lists.newArrayList(this.domains);
            tempDomains.add(AqlDomainEnum.items);
            return new AqlApiItemDynamicFieldsDomains(tempDomains);
        }
    }

    public static class AqlApiReleaseBundleDynamicFieldsDomains<T extends AqlBase> {
        private final List<AqlDomainEnum> domains = Lists.newArrayList();

        public AqlApiReleaseBundleDynamicFieldsDomains(ArrayList<AqlDomainEnum> domains) {
            this.domains.addAll(domains);
        }

        public AqlApiComparator<T> id() {
            return new AqlApiComparator(AqlPhysicalFieldEnum.releaseBundleId, this.domains);
        }

        public AqlApiComparator<T> name() {
            return new AqlApiComparator(AqlPhysicalFieldEnum.releaseBundleName, this.domains);
        }

        public AqlApiComparator<T> version() {
            return new AqlApiComparator(AqlPhysicalFieldEnum.releaseBundleVersion, this.domains);
        }

        public AqlApiComparator<T> status() {
            return new AqlApiComparator(AqlPhysicalFieldEnum.releaseBundleStatus, this.domains);
        }

        public AqlApiComparator<T> created() {
            return new AqlApiComparator(AqlPhysicalFieldEnum.releaseBundleCreated, this.domains);
        }

        public AqlApiComparator<T> signature() {
            return new AqlApiComparator(AqlPhysicalFieldEnum.releaseBundleSignature, this.domains);
        }

        public AqlApiComparator<T> bundleType() {
            return new AqlApiComparator(AqlPhysicalFieldEnum.releaseBundleType, this.domains);
        }

        public AqlApiReleaseBundleFileDynamicFieldsDomains<T> releaseArtifact() {
            ArrayList tempDomains = Lists.newArrayList(this.domains);
            tempDomains.add(AqlDomainEnum.releaseBundleFiles);
            return new AqlApiReleaseBundleFileDynamicFieldsDomains(tempDomains);
        }
    }

    public static class AqlApiStatisticDynamicFieldsDomains<T extends AqlBase> {
        private final List<AqlDomainEnum> domains = Lists.newArrayList();

        public AqlApiStatisticDynamicFieldsDomains(ArrayList<AqlDomainEnum> domains) {
            this.domains.addAll(domains);
        }

        public AqlApiComparator<T> statId() {
            return new AqlApiComparator(AqlPhysicalFieldEnum.statId, this.domains);
        }

        public AqlApiComparator<T> downloads() {
            return new AqlApiComparator(AqlPhysicalFieldEnum.statDownloads, this.domains);
        }

        public AqlApiComparator<T> downloaded() {
            return new AqlApiComparator(AqlPhysicalFieldEnum.statDownloaded, this.domains);
        }

        public AqlApiComparator<T> downloadedBy() {
            return new AqlApiComparator(AqlPhysicalFieldEnum.statDownloadedBy, this.domains);
        }

        public AqlApiComparator<T> remoteDownloads() {
            return new AqlApiComparator(AqlPhysicalFieldEnum.statRemoteDownloadedBy, this.domains);
        }

        public AqlApiComparator<T> remoteDownloaded() {
            return new AqlApiComparator(AqlPhysicalFieldEnum.statRemoteDownloaded, this.domains);
        }

        public AqlApiComparator<T> remoteDownloadedBy() {
            return new AqlApiComparator(AqlPhysicalFieldEnum.statRemoteDownloadedBy, this.domains);
        }

        public AqlApiComparator<T> remoteOrigin() {
            return new AqlApiComparator(AqlPhysicalFieldEnum.statRemoteDownloadedBy, this.domains);
        }

        public AqlApiComparator<T> remotePath() {
            return new AqlApiComparator(AqlPhysicalFieldEnum.statRemoteDownloadedBy, this.domains);
        }

        public AqlApiItemDynamicFieldsDomains<T> item() {
            ArrayList tempDomains = Lists.newArrayList(this.domains);
            tempDomains.add(AqlDomainEnum.items);
            return new AqlApiItemDynamicFieldsDomains(tempDomains);
        }
    }

    public static class AqlApiBuildPromotionDynamicFieldsDomains<T extends AqlBase> {
        private final List<AqlDomainEnum> domains = Lists.newArrayList();

        public AqlApiBuildPromotionDynamicFieldsDomains(List<AqlDomainEnum> domains) {
            this.domains.addAll(domains);
        }

        public AqlApiComparator<T> created() {
            return new AqlApiComparator(AqlPhysicalFieldEnum.buildPromotionCreated, this.domains);
        }

        public AqlApiComparator<T> createdBy() {
            return new AqlApiComparator(AqlPhysicalFieldEnum.buildPromotionCreatedBy, this.domains);
        }

        public AqlApiComparator<T> userName() {
            return new AqlApiComparator(AqlPhysicalFieldEnum.buildPromotionUserName, this.domains);
        }

        public AqlApiComparator<T> comment() {
            return new AqlApiComparator(AqlPhysicalFieldEnum.buildPromotionComment, this.domains);
        }

        public AqlApiComparator<T> repo() {
            return new AqlApiComparator(AqlPhysicalFieldEnum.buildPromotionRepo, this.domains);
        }

        public AqlApiComparator<T> status() {
            return new AqlApiComparator(AqlPhysicalFieldEnum.buildPromotionStatus, this.domains);
        }

        public AqlApiBuildDynamicFieldsDomains<T> build() {
            ArrayList tempDomains = Lists.newArrayList(this.domains);
            tempDomains.add(AqlDomainEnum.builds);
            return new AqlApiBuildDynamicFieldsDomains(tempDomains);
        }
    }

    public static class AqlApiBuildPropertyDynamicFieldsDomains<T extends AqlBase> {
        private final List<AqlDomainEnum> domains = Lists.newArrayList();

        public AqlApiBuildPropertyDynamicFieldsDomains(List<AqlDomainEnum> domains) {
            this.domains.addAll(domains);
        }

        public AqlApiComparator<T> key() {
            return new AqlApiComparator(AqlPhysicalFieldEnum.buildPropertyKey, this.domains);
        }

        public AqlApiComparator<T> value() {
            return new AqlApiComparator(AqlPhysicalFieldEnum.buildPropertyValue, this.domains);
        }

        public AqlApiBuildDynamicFieldsDomains<T> build() {
            ArrayList tempDomains = Lists.newArrayList(this.domains);
            tempDomains.add(AqlDomainEnum.builds);
            return new AqlApiBuildDynamicFieldsDomains(tempDomains);
        }
    }

    public static class AqlApiItemPropertyDynamicFieldsDomains<T extends AqlBase> {
        private final List<AqlDomainEnum> domains = Lists.newArrayList();

        public AqlApiItemPropertyDynamicFieldsDomains(ArrayList<AqlDomainEnum> domains) {
            this.domains.addAll(domains);
        }

        public AqlApiComparator<T> propertyId() {
            return new AqlApiComparator(AqlPhysicalFieldEnum.propertyId, this.domains);
        }

        public AqlApiComparator<T> propertyItemId() {
            return new AqlApiComparator(AqlPhysicalFieldEnum.propertyItemId, this.domains);
        }

        public AqlBase.PropertyCriteriaClause<T> property(String key, AqlComparatorEnum comparator, String value) {
            return new AqlBase.PropertyCriteriaClause(key, comparator, value, this.domains);
        }

        public AqlApiComparator<T> key() {
            return new AqlApiComparator(AqlPhysicalFieldEnum.propertyKey, this.domains);
        }

        public AqlApiComparator<T> value() {
            return new AqlApiComparator(AqlPhysicalFieldEnum.propertyValue, this.domains);
        }

        public AqlApiItemDynamicFieldsDomains<T> item() {
            ArrayList tempDomains = Lists.newArrayList(this.domains);
            tempDomains.add(AqlDomainEnum.items);
            return new AqlApiItemDynamicFieldsDomains(tempDomains);
        }
    }

    public static class AqlApiModuleDynamicFieldsDomains<T extends AqlBase> {
        private List<AqlDomainEnum> domains = Lists.newArrayList();

        public AqlApiModuleDynamicFieldsDomains(List<AqlDomainEnum> domains) {
            this.domains.addAll(domains);
        }

        public AqlApiComparator<T> name() {
            return new AqlApiComparator(AqlPhysicalFieldEnum.moduleName, this.domains);
        }

        public AqlApiBuildDynamicFieldsDomains<T> build() {
            ArrayList tempDomains = Lists.newArrayList(this.domains);
            tempDomains.add(AqlDomainEnum.builds);
            return new AqlApiBuildDynamicFieldsDomains(tempDomains);
        }

        public AqlApiArtifactDynamicFieldsDomains<T> artifact() {
            ArrayList tempDomains = Lists.newArrayList(this.domains);
            tempDomains.add(AqlDomainEnum.artifacts);
            return new AqlApiArtifactDynamicFieldsDomains(tempDomains);
        }

        public AqlApiDependencyDynamicFieldsDomains<T> dependecy() {
            ArrayList tempDomains = Lists.newArrayList(this.domains);
            tempDomains.add(AqlDomainEnum.dependencies);
            return new AqlApiDependencyDynamicFieldsDomains(tempDomains);
        }
    }

    public static class AqlApiDependencyDynamicFieldsDomains<T extends AqlBase> {
        private ArrayList<AqlDomainEnum> domains = Lists.newArrayList();

        public AqlApiDependencyDynamicFieldsDomains(ArrayList<AqlDomainEnum> domains) {
            this.domains.addAll(domains);
        }

        public AqlApiComparator<T> name() {
            return new AqlApiComparator(AqlPhysicalFieldEnum.buildDependencyName, this.domains);
        }

        public AqlApiComparator<T> scope() {
            return new AqlApiComparator(AqlPhysicalFieldEnum.buildDependencyScope, this.domains);
        }

        public AqlApiComparator<T> type() {
            return new AqlApiComparator(AqlPhysicalFieldEnum.buildDependencyType, this.domains);
        }

        public AqlApiComparator<T> sha1() {
            return new AqlApiComparator(AqlPhysicalFieldEnum.buildDependencySha1, this.domains);
        }

        public AqlApiComparator<T> md5() {
            return new AqlApiComparator(AqlPhysicalFieldEnum.buildDependencyMd5, this.domains);
        }

        public AqlApiItemDynamicFieldsDomains<T> item() {
            ArrayList tempDomains = Lists.newArrayList(this.domains);
            tempDomains.add(AqlDomainEnum.items);
            return new AqlApiItemDynamicFieldsDomains(tempDomains);
        }

        public AqlApiModuleDynamicFieldsDomains<T> module() {
            ArrayList tempDomains = Lists.newArrayList(this.domains);
            tempDomains.add(AqlDomainEnum.modules);
            return new AqlApiModuleDynamicFieldsDomains(tempDomains);
        }
    }

    public static class AqlApiArtifactDynamicFieldsDomains<T extends AqlBase> {
        private ArrayList<AqlDomainEnum> domains = Lists.newArrayList();

        public AqlApiArtifactDynamicFieldsDomains(ArrayList<AqlDomainEnum> domains) {
            this.domains.addAll(domains);
        }

        public AqlApiComparator<T> name() {
            return new AqlApiComparator(AqlPhysicalFieldEnum.buildArtifactName, this.domains);
        }

        public AqlApiComparator<T> type() {
            return new AqlApiComparator(AqlPhysicalFieldEnum.buildArtifactType, this.domains);
        }

        public AqlApiComparator<T> sha1() {
            return new AqlApiComparator(AqlPhysicalFieldEnum.buildArtifactSha1, this.domains);
        }

        public AqlApiComparator<T> md5() {
            return new AqlApiComparator(AqlPhysicalFieldEnum.buildArtifactMd5, this.domains);
        }

        public AqlApiModuleDynamicFieldsDomains<T> module() {
            ArrayList tempDomains = Lists.newArrayList(this.domains);
            tempDomains.add(AqlDomainEnum.modules);
            return new AqlApiModuleDynamicFieldsDomains(tempDomains);
        }

        public AqlApiItemDynamicFieldsDomains<T> item() {
            ArrayList tempDomains = Lists.newArrayList(this.domains);
            tempDomains.add(AqlDomainEnum.items);
            return new AqlApiItemDynamicFieldsDomains(tempDomains);
        }
    }

    public static class AqlApiBuildDynamicFieldsDomains<T extends AqlBase> {
        private List<AqlDomainEnum> domains = Lists.newArrayList();

        public AqlApiBuildDynamicFieldsDomains(List<AqlDomainEnum> domains) {
            this.domains.addAll(domains);
        }

        public AqlApiComparator<T> name() {
            return new AqlApiComparator(AqlPhysicalFieldEnum.buildName, this.domains);
        }

        public AqlApiComparator<T> number() {
            return new AqlApiComparator(AqlPhysicalFieldEnum.buildNumber, this.domains);
        }

        public AqlApiModuleDynamicFieldsDomains<T> module() {
            ArrayList tempDomains = Lists.newArrayList(this.domains);
            tempDomains.add(AqlDomainEnum.modules);
            return new AqlApiModuleDynamicFieldsDomains(tempDomains);
        }

        public AqlApiBuildPropertyDynamicFieldsDomains<T> property() {
            ArrayList tempDomains = Lists.newArrayList(this.domains);
            tempDomains.add(AqlDomainEnum.buildProperties);
            return new AqlApiBuildPropertyDynamicFieldsDomains(tempDomains);
        }

        public AqlApiBuildPromotionDynamicFieldsDomains<T> promotion() {
            ArrayList tempDomains = Lists.newArrayList(this.domains);
            tempDomains.add(AqlDomainEnum.buildPromotions);
            return new AqlApiBuildPromotionDynamicFieldsDomains(tempDomains);
        }
    }

    public static class AqlApiArchiveEntryDynamicFieldsDomains<T extends AqlBase> {
        private List<AqlDomainEnum> domains = Lists.newArrayList();

        public AqlApiArchiveEntryDynamicFieldsDomains(List<AqlDomainEnum> domains) {
            this.domains.addAll(domains);
        }

        public AqlApiComparator<T> name() {
            return new AqlApiComparator(AqlPhysicalFieldEnum.archiveEntryName, this.domains);
        }

        public AqlApiComparator<T> path() {
            return new AqlApiComparator(AqlPhysicalFieldEnum.archiveEntryPath, this.domains);
        }

        public AqlApiArchiveDynamicFieldsDomains<T> archive() {
            ArrayList tempDomains = Lists.newArrayList(this.domains);
            tempDomains.add(AqlDomainEnum.archives);
            return new AqlApiArchiveDynamicFieldsDomains(tempDomains);
        }
    }

    public static class AqlApiArchiveDynamicFieldsDomains<T extends AqlBase> {
        private List<AqlDomainEnum> domains = Lists.newArrayList();

        public AqlApiArchiveDynamicFieldsDomains(List<AqlDomainEnum> domains) {
            this.domains.addAll(domains);
        }

        public AqlApiItemDynamicFieldsDomains<T> item() {
            ArrayList tempDomains = Lists.newArrayList(this.domains);
            tempDomains.add(AqlDomainEnum.items);
            return new AqlApiItemDynamicFieldsDomains(tempDomains);
        }

        public AqlApiArchiveEntryDynamicFieldsDomains<T> entry() {
            ArrayList tempDomains = Lists.newArrayList(this.domains);
            tempDomains.add(AqlDomainEnum.entries);
            return new AqlApiArchiveEntryDynamicFieldsDomains(tempDomains);
        }
    }

    public static class AqlApiItemDynamicFieldsDomains<T extends AqlBase> {
        private List<AqlDomainEnum> domains = Lists.newArrayList();

        public AqlApiItemDynamicFieldsDomains(List<AqlDomainEnum> domains) {
            this.domains.addAll(domains);
        }

        public AqlApiComparator<T> size() {
            return new AqlApiComparator(AqlPhysicalFieldEnum.itemSize, this.domains);
        }

        public AqlApiComparator<T> updated() {
            return new AqlApiComparator(AqlPhysicalFieldEnum.itemUpdated, this.domains);
        }

        public AqlApiComparator<T> itemId() {
            return new AqlApiComparator(AqlPhysicalFieldEnum.itemId, this.domains);
        }

        public AqlApiComparator<T> repo() {
            return new AqlApiComparator(AqlPhysicalFieldEnum.itemRepo, this.domains);
        }

        public AqlApiComparator<T> path() {
            return new AqlApiComparator(AqlPhysicalFieldEnum.itemPath, this.domains);
        }

        public AqlApiComparator<T> name() {
            return new AqlApiComparator(AqlPhysicalFieldEnum.itemName, this.domains);
        }

        public AqlApiComparator<T> type() {
            return new AqlApiComparator(AqlPhysicalFieldEnum.itemType, this.domains);
        }

        public AqlApiComparator<T> created() {
            return new AqlApiComparator(AqlPhysicalFieldEnum.itemCreated, this.domains);
        }

        public AqlApiComparator<T> createdBy() {
            return new AqlApiComparator(AqlPhysicalFieldEnum.itemCreatedBy, this.domains);
        }

        public AqlApiComparator<T> modified() {
            return new AqlApiComparator(AqlPhysicalFieldEnum.itemModified, this.domains);
        }

        public AqlApiComparator<T> modifiedBy() {
            return new AqlApiComparator(AqlPhysicalFieldEnum.itemModifiedBy, this.domains);
        }

        public AqlApiComparator<T> sha1Actual() {
            return new AqlApiComparator(AqlPhysicalFieldEnum.itemActualSha1, this.domains);
        }

        public AqlApiComparator<T> sha1Original() {
            return new AqlApiComparator(AqlPhysicalFieldEnum.itemOriginalSha1, this.domains);
        }

        public AqlApiComparator<T> md5Actual() {
            return new AqlApiComparator(AqlPhysicalFieldEnum.itemActualMd5, this.domains);
        }

        public AqlApiComparator<T> md5Orginal() {
            return new AqlApiComparator(AqlPhysicalFieldEnum.itemOriginalMd5, this.domains);
        }

        public AqlApiComparator<T> depth() {
            return new AqlApiComparator(AqlPhysicalFieldEnum.itemDepth, this.domains);
        }

        public AqlApiComparator<T> sha2() {
            return new AqlApiComparator(AqlPhysicalFieldEnum.itemSha2, this.domains);
        }

        public AqlApiComparator<T> repoPathChecksum() {
            return new AqlApiComparator(AqlPhysicalFieldEnum.repoPathChecksum, this.domains);
        }

        public AqlApiField<T> virtualRepos() {
            return new AqlApiField(AqlLogicalFieldEnum.itemVirtualRepos, this.domains);
        }

        public AqlApiArchiveDynamicFieldsDomains<T> archive() {
            ArrayList tempDomains = Lists.newArrayList(this.domains);
            tempDomains.add(AqlDomainEnum.archives);
            return new AqlApiArchiveDynamicFieldsDomains(tempDomains);
        }

        public AqlApiItemPropertyDynamicFieldsDomains<T> property() {
            ArrayList tempDomains = Lists.newArrayList(this.domains);
            tempDomains.add(AqlDomainEnum.properties);
            return new AqlApiItemPropertyDynamicFieldsDomains(tempDomains);
        }

        public AqlApiStatisticDynamicFieldsDomains<T> statistic() {
            ArrayList tempDomains = Lists.newArrayList(this.domains);
            tempDomains.add(AqlDomainEnum.statistics);
            return new AqlApiStatisticDynamicFieldsDomains(tempDomains);
        }

        public AqlApiArtifactDynamicFieldsDomains<T> artifact() {
            ArrayList tempDomains = Lists.newArrayList(this.domains);
            tempDomains.add(AqlDomainEnum.artifacts);
            return new AqlApiArtifactDynamicFieldsDomains(tempDomains);
        }

        public AqlApiDependencyDynamicFieldsDomains<T> dependency() {
            ArrayList tempDomains = Lists.newArrayList(this.domains);
            tempDomains.add(AqlDomainEnum.dependencies);
            return new AqlApiDependencyDynamicFieldsDomains(tempDomains);
        }

        public AqlApiReleaseBundleDynamicFieldsDomains<T> bundledFile() {
            ArrayList tempDomains = Lists.newArrayList(this.domains);
            tempDomains.add(AqlDomainEnum.releaseBundleFiles);
            return new AqlApiReleaseBundleDynamicFieldsDomains(tempDomains);
        }
    }
}

