/*
 * Decompiled with CFR 0.152.
 */
package org.artifactory.api.util;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class StringKeyIgnoreCaseHashMap<V>
implements Map<String, V> {
    private final Map<String, V> map = Maps.newHashMap();
    private final Map<String, String> originalKeys = Maps.newHashMap();

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(this.normalizeKey(key));
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public V get(Object key) {
        return this.map.get(this.normalizeKey(key));
    }

    @Override
    public V put(String key, V value) {
        String normalizedKey = this.normalizeKey(key);
        this.originalKeys.put(normalizedKey, key);
        return this.map.put(normalizedKey, value);
    }

    @Override
    public V remove(Object key) {
        return this.map.remove(this.normalizeKey(key));
    }

    @Override
    public void putAll(Map<? extends String, ? extends V> m) {
        m.entrySet().forEach((? super T entry) -> this.put((String)entry.getKey(), entry.getValue()));
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public Set<String> keySet() {
        return Sets.newHashSet(this.originalKeys.values());
    }

    @Override
    public Collection<V> values() {
        return this.map.values();
    }

    @Override
    public Set<Map.Entry<String, V>> entrySet() {
        return this.map.entrySet().stream().map(entry -> new MapEntry((Map.Entry)entry, this.originalKeys.get(entry.getKey()))).collect(Collectors.toSet());
    }

    private String normalizeKey(Object key) {
        return key == null ? null : String.valueOf(key).toLowerCase();
    }

    private static class MapEntry<V>
    implements Map.Entry<String, V> {
        private final Map.Entry<String, V> entry;
        private final String originalKey;

        private MapEntry(Map.Entry<String, V> entry, String originalKey) {
            this.entry = entry;
            this.originalKey = originalKey;
        }

        @Override
        public String getKey() {
            return this.originalKey;
        }

        @Override
        public V getValue() {
            return this.entry.getValue();
        }

        @Override
        public V setValue(V value) {
            return this.entry.setValue(value);
        }
    }
}

