/*
 * Decompiled with CFR 0.152.
 */
package org.artifactory.api.search;

import java.util.Calendar;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.artifactory.api.rest.search.common.RestDateFieldName;
import org.artifactory.api.search.ItemSearchResults;
import org.artifactory.api.search.archive.ArchiveSearchControls;
import org.artifactory.api.search.archive.ArchiveSearchResult;
import org.artifactory.api.search.artifact.ArtifactSearchControls;
import org.artifactory.api.search.artifact.ArtifactSearchResult;
import org.artifactory.api.search.artifact.ChecksumSearchControls;
import org.artifactory.api.search.exception.InvalidChecksumException;
import org.artifactory.api.search.gavc.GavcSearchControls;
import org.artifactory.api.search.gavc.GavcSearchResult;
import org.artifactory.api.search.property.PropertySearchControls;
import org.artifactory.api.search.property.PropertySearchResult;
import org.artifactory.api.search.stats.StatsSearchResult;
import org.artifactory.aql.result.rows.AqlStatistics;
import org.artifactory.build.BuildRun;
import org.artifactory.fs.ItemInfo;
import org.artifactory.repo.RepoPath;
import org.artifactory.sapi.common.RepositoryRuntimeException;

public interface SearchService {
    public ItemSearchResults<ArtifactSearchResult> searchArtifacts(ArtifactSearchControls var1);

    public Set<RepoPath> searchArtifactsByChecksum(ChecksumSearchControls var1) throws InvalidChecksumException;

    public ItemSearchResults<ArtifactSearchResult> getArtifactsByChecksumResults(ChecksumSearchControls var1) throws InvalidChecksumException;

    public ItemSearchResults<ArtifactSearchResult> searchArtifactsInRange(Calendar var1, Calendar var2, List<String> var3, RestDateFieldName ... var4);

    public Stream<AqlStatistics> getRemoteDownloadedSinceEventsStatistics(@Nonnull RepoPath var1, long var2);

    public Stream<AqlStatistics> getDownloadedSinceEventsStatistics(@Nonnull RepoPath var1, long var2);

    public Stream<StatsSearchResult> streamStatsForArtifactsNotDownloadedSince(@Nullable Calendar var1, @Nullable Calendar var2, String ... var3);

    public Stream<RepoPath> streamArtifactsRepoPathNotDownloadedSince(@Nullable Calendar var1, @Nullable Calendar var2, String ... var3);

    public Stream<ItemInfo> streamArtifactsItemInfoNotDownloadedSince(@Nullable Calendar var1, @Nullable Calendar var2, String ... var3);

    public ItemSearchResults<ArchiveSearchResult> searchArchiveContent(ArchiveSearchControls var1);

    public ItemSearchResults<ArchiveSearchResult> searchArchiveContentAql(ArchiveSearchControls var1);

    public ItemSearchResults<GavcSearchResult> searchGavc(GavcSearchControls var1);

    public ItemSearchResults<PropertySearchResult> searchProperty(PropertySearchControls var1);

    public ItemSearchResults<PropertySearchResult> searchPropertyAql(PropertySearchControls var1);

    public Set<BuildRun> getLatestBuilds() throws RepositoryRuntimeException;

    public Set<BuildRun> findBuildsByArtifactChecksum(@Nullable String var1, @Nullable String var2, @Nullable String var3) throws RepositoryRuntimeException;

    public Set<BuildRun> findBuildsByDependencyChecksum(@Nullable String var1, @Nullable String var2, @Nullable String var3) throws RepositoryRuntimeException;

    public Set<String> searchArtifactsByPattern(String var1) throws ExecutionException, InterruptedException, TimeoutException;
}

