/*
 * Decompiled with CFR 0.152.
 */
package org.artifactory.api.search;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.artifactory.api.search.ItemSearchResult;

@XStreamAlias(value="searchResults")
public class ItemSearchResults<T extends ItemSearchResult>
implements Serializable {
    @XStreamImplicit(itemFieldName="searchResult")
    private Stream<T> results;
    private List<T> resultsList = null;
    private long fullResultsCount;
    private long time;

    public ItemSearchResults(List<T> results) {
        this.results = results.stream();
        this.fullResultsCount = -1L;
    }

    public ItemSearchResults(Stream<T> results) {
        this.results = results;
        this.fullResultsCount = -1L;
    }

    public ItemSearchResults(List<T> results, long count) {
        this.results = results.stream();
        this.fullResultsCount = count;
    }

    public List<T> getResults() {
        if (this.resultsList == null) {
            this.resultsList = this.results.collect(Collectors.toList());
        }
        return this.resultsList;
    }

    public void setResults(List<T> results) {
        this.results = results.stream();
        this.resultsList = null;
    }

    public Stream<T> getStream() {
        return this.results;
    }

    public long getFullResultsCount() {
        return this.fullResultsCount;
    }

    public void setFullResultsCount(long fullResultsCount) {
        this.fullResultsCount = fullResultsCount;
    }

    public long getTime() {
        return this.time;
    }

    public void setTime(long time) {
        this.time = time;
    }
}

