/*
 * Decompiled with CFR 0.152.
 */
package org.artifactory.api.rest.replication;

import org.artifactory.api.rest.replication.ReplicationStatus;
import org.artifactory.api.rest.replication.ReplicationStatusType;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.jfrog.client.util.PathUtils;

public class ReplicationTarget {
    private String url;
    private String repoKey;
    private ReplicationStatusType status;
    private String lastCompleted;

    public ReplicationTarget(String fullRepoPath, ReplicationStatus status) {
        this.repoKey = PathUtils.getLastPathElement((String)fullRepoPath);
        this.url = fullRepoPath;
        this.status = status.getType();
        this.lastCompleted = status.getLastCompleted();
    }

    public String getUrl() {
        return this.url;
    }

    public String getRepoKey() {
        return this.repoKey;
    }

    public String getStatus() {
        return this.status.getId();
    }

    public String getLastCompleted() {
        return this.lastCompleted;
    }

    @JsonIgnore
    public ReplicationStatusType getType() {
        return this.status;
    }

    public void setLastCompleted(String lastCompleted) {
        this.lastCompleted = lastCompleted;
    }

    public void setStatus(String status) {
        this.status = ReplicationStatusType.findTypeById(status);
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setRepoKey(String repoKey) {
        this.repoKey = repoKey;
    }

    @JsonIgnore
    public Boolean replicationStatusByFullRepoPathExists(String fullRepoPath) {
        return this.url.equals(fullRepoPath);
    }
}

