/*
 * Decompiled with CFR 0.152.
 */
package org.artifactory.api.rest.artifact;

import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.Map;

public class FileListElement
implements Serializable {
    String uri;
    long size;
    String lastModified;
    boolean folder;
    String sha1;
    String sha2;
    Map<String, String> mdTimestamps;

    public FileListElement() {
    }

    public FileListElement(String uri, long size, String lastModified, boolean folder) {
        this.uri = uri;
        this.size = size;
        this.lastModified = lastModified;
        this.folder = folder;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public String getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(String lastModified) {
        this.lastModified = lastModified;
    }

    public boolean isFolder() {
        return this.folder;
    }

    public void setFolder(boolean folder) {
        this.folder = folder;
    }

    public String getSha1() {
        return this.sha1;
    }

    public void setSha1(String sha1) {
        this.sha1 = sha1;
    }

    public String getSha2() {
        return this.sha2;
    }

    public void setSha2(String sha2) {
        this.sha2 = sha2;
    }

    public Map<String, String> getMdTimestamps() {
        return this.mdTimestamps;
    }

    public void setMdTimestamps(Map<String, String> mdTimestamps) {
        this.mdTimestamps = mdTimestamps;
    }

    public void addMdTimestamp(String metadataName, String timestamp) {
        if (this.mdTimestamps == null) {
            this.mdTimestamps = Maps.newHashMap();
        }
        this.mdTimestamps.put(metadataName, timestamp);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FileListElement)) {
            return false;
        }
        FileListElement that = (FileListElement)o;
        if (this.folder != that.folder) {
            return false;
        }
        if (this.size != that.size) {
            return false;
        }
        if (this.lastModified != null ? !this.lastModified.equals(that.lastModified) : that.lastModified != null) {
            return false;
        }
        return this.uri != null ? this.uri.equals(that.uri) : that.uri == null;
    }

    public int hashCode() {
        int result = this.uri != null ? this.uri.hashCode() : 0;
        result = 31 * result + (int)(this.size ^ this.size >>> 32);
        result = 31 * result + (this.lastModified != null ? this.lastModified.hashCode() : 0);
        result = 31 * result + (this.folder ? 1 : 0);
        return result;
    }

    public String toString() {
        return this.uri;
    }
}

