/*
 * Decompiled with CFR 0.152.
 */
package org.artifactory.api.request;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Map;
import javax.annotation.Nonnull;
import org.artifactory.md.Properties;
import org.artifactory.mime.NamingUtils;
import org.artifactory.repo.RepoPath;
import org.artifactory.request.ArtifactoryRequest;
import org.jfrog.client.util.PathUtils;

public class TranslatedArtifactoryRequest
implements ArtifactoryRequest {
    private RepoPath translatedRepoPath;
    private ArtifactoryRequest originalRequest;

    public TranslatedArtifactoryRequest(RepoPath translatedRepoPath, ArtifactoryRequest originalRequest) {
        this.translatedRepoPath = translatedRepoPath;
        this.originalRequest = originalRequest;
    }

    @Override
    public String getRepoKey() {
        return this.translatedRepoPath.getRepoKey();
    }

    @Override
    public String getPath() {
        return this.translatedRepoPath.getPath();
    }

    public String getClientAddress() {
        return this.originalRequest.getClientAddress();
    }

    @Override
    public boolean isMetadata() {
        return NamingUtils.isMetadata((String)this.getPath());
    }

    @Override
    public boolean isRecursive() {
        return this.originalRequest.isRecursive();
    }

    @Override
    public long getModificationTime() {
        return this.originalRequest.getModificationTime();
    }

    @Override
    public String getName() {
        return PathUtils.getFileName((String)this.getPath());
    }

    @Override
    public boolean isDirectoryRequest() {
        return this.originalRequest.isDirectoryRequest();
    }

    public RepoPath getRepoPath() {
        return this.translatedRepoPath;
    }

    public boolean isChecksum() {
        return NamingUtils.isChecksum((String)this.getPath()) || NamingUtils.isChecksum((String)this.originalRequest.getZipResourcePath());
    }

    public boolean isFromAnotherArtifactory() {
        return this.originalRequest.isFromAnotherArtifactory();
    }

    public boolean isHeadOnly() {
        return this.originalRequest.isHeadOnly();
    }

    public long getLastModified() {
        return this.originalRequest.getLastModified();
    }

    public long getIfModifiedSince() {
        return this.originalRequest.getIfModifiedSince();
    }

    public boolean hasIfModifiedSince() {
        return this.originalRequest.hasIfModifiedSince();
    }

    public boolean isNewerThan(long time) {
        return this.originalRequest.isNewerThan(time);
    }

    public Enumeration<String> getHeadersKeys() {
        return this.originalRequest.getHeadersKeys();
    }

    public Enumeration<String> getHeaderValues(@Nonnull String headerName) {
        return this.originalRequest.getHeaderValues(headerName);
    }

    public String getServletContextUrl() {
        return this.originalRequest.getServletContextUrl();
    }

    public String getUri() {
        return this.originalRequest.getUri();
    }

    public Properties getProperties() {
        return this.originalRequest.getProperties();
    }

    public boolean hasProperties() {
        return this.originalRequest.hasProperties();
    }

    public Map<String, String[]> getParameters() {
        return this.originalRequest.getParameters();
    }

    public String getZipResourcePath() {
        return this.originalRequest.getZipResourcePath();
    }

    public boolean isZipResourceRequest() {
        return this.originalRequest.isZipResourceRequest();
    }

    public String getParameter(String name) {
        return this.originalRequest.getParameter(name);
    }

    public String[] getParameterValues(String name) {
        return this.originalRequest.getParameterValues(name);
    }

    public InputStream getInputStream() throws IOException {
        return this.originalRequest.getInputStream();
    }

    public long getContentLength() {
        return this.originalRequest.getContentLength();
    }

    public boolean isNoneMatch(String etag) {
        return this.originalRequest.isNoneMatch(etag);
    }

    public boolean hasIfNoneMatch() {
        return this.originalRequest.hasIfNoneMatch();
    }

    public String toString() {
        return "source=" + this.getClientAddress() + ", path=" + this.getPath() + ", lastModified=" + this.getLastModified() + ", ifModifiedSince=" + this.getIfModifiedSince();
    }
}

