/*
 * Decompiled with CFR 0.152.
 */
package org.artifactory.api.module;

import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.artifactory.api.module.ModuleInfo;
import org.artifactory.repo.RepoPath;

public class VersionUnit
implements Serializable {
    private final ModuleInfo moduleInfo;
    private final Set<RepoPath> repoPaths;
    private final Set<RepoPath> parents;

    public VersionUnit(ModuleInfo moduleInfo, Set<RepoPath> repoPaths) {
        this.moduleInfo = moduleInfo;
        this.repoPaths = repoPaths;
        this.parents = this.getParents(repoPaths);
    }

    private Set<RepoPath> getParents(Set<RepoPath> repoPaths) {
        HashSet parentSet = Sets.newHashSet();
        for (RepoPath repoPath : repoPaths) {
            parentSet.add(repoPath.getParent());
        }
        return parentSet;
    }

    public ModuleInfo getModuleInfo() {
        return this.moduleInfo;
    }

    public Set<RepoPath> getRepoPaths() {
        return this.repoPaths;
    }

    public Set<RepoPath> getParents() {
        return this.parents;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VersionUnit)) {
            return false;
        }
        VersionUnit that = (VersionUnit)o;
        if (this.moduleInfo != null ? !this.moduleInfo.equals(that.moduleInfo) : that.moduleInfo != null) {
            return false;
        }
        return this.repoPaths != null ? this.repoPaths.equals(that.repoPaths) : that.repoPaths == null;
    }

    public int hashCode() {
        int result = this.moduleInfo != null ? this.moduleInfo.hashCode() : 0;
        result = 31 * result + (this.repoPaths != null ? this.repoPaths.hashCode() : 0);
        return result;
    }
}

