/*
 * Decompiled with CFR 0.152.
 */
package org.artifactory.api.module;

import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.Map;
import org.artifactory.api.module.ModuleInfo;
import org.artifactory.fs.FileLayoutInfo;

public class ModuleInfoBuilder
implements Serializable {
    private String organization = null;
    private String module = null;
    private String baseRevision = null;
    private String folderIntegrationRevision = null;
    private String fileIntegrationRevision = null;
    private String classifier = null;
    private String ext = null;
    private String type = null;
    private Map<String, String> customFields;

    public ModuleInfoBuilder() {
    }

    public ModuleInfoBuilder(FileLayoutInfo copy) {
        this.organization = copy.getOrganization();
        this.module = copy.getModule();
        this.baseRevision = copy.getBaseRevision();
        this.folderIntegrationRevision = copy.getFolderIntegrationRevision();
        this.fileIntegrationRevision = copy.getFileIntegrationRevision();
        this.classifier = copy.getClassifier();
        this.ext = copy.getExt();
        this.type = copy.getType();
        Map customFields = copy.getCustomFields();
        if (customFields != null) {
            this.customFields = Maps.newHashMap((Map)customFields);
        }
    }

    public ModuleInfoBuilder organization(String organization) {
        this.organization = organization;
        return this;
    }

    public ModuleInfoBuilder module(String module) {
        this.module = module;
        return this;
    }

    public ModuleInfoBuilder baseRevision(String baseRevision) {
        this.baseRevision = baseRevision;
        return this;
    }

    public ModuleInfoBuilder folderIntegrationRevision(String folderIntegrationRevision) {
        this.folderIntegrationRevision = folderIntegrationRevision;
        return this;
    }

    public ModuleInfoBuilder fileIntegrationRevision(String fileIntegrationRevision) {
        this.fileIntegrationRevision = fileIntegrationRevision;
        return this;
    }

    public ModuleInfoBuilder classifier(String classifier) {
        this.classifier = classifier;
        return this;
    }

    public ModuleInfoBuilder ext(String ext) {
        this.ext = ext;
        return this;
    }

    public ModuleInfoBuilder type(String type) {
        this.type = type;
        return this;
    }

    ModuleInfoBuilder customField(String tokenName, String tokenValue) {
        if (this.customFields == null) {
            this.customFields = Maps.newHashMap();
        }
        this.customFields.put(tokenName, tokenValue);
        return this;
    }

    public ModuleInfo build() {
        return new ModuleInfo(this.organization, this.module, this.baseRevision, this.folderIntegrationRevision, this.fileIntegrationRevision, this.classifier, this.ext, this.type, this.customFields);
    }
}

