/*
 * Decompiled with CFR 0.152.
 */
package org.artifactory.api.mime;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class MimeEntry {
    private final String type;
    private final String subType;
    private final List<String> fileExts;

    public MimeEntry(String mime, String ... exts) {
        if (mime.indexOf(47) == -1) {
            throw new IllegalArgumentException("MIME type '" + mime + "' is not valid");
        }
        String[] parts = mime.split("/", 2);
        this.type = parts[0].toLowerCase();
        this.subType = parts[1].toLowerCase();
        this.fileExts = Arrays.asList(exts);
    }

    public String getType() {
        return this.type;
    }

    public String getSubType() {
        return this.subType;
    }

    public void addFileExt(String fileExt) {
        this.fileExts.add(fileExt);
    }

    public Collection<String> getFileExts() {
        return this.fileExts;
    }

    public String getMimeType() {
        return this.type + "/" + this.subType;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getMimeType()).append(' ');
        for (String ext : this.fileExts) {
            sb.append(' ').append(ext);
        }
        return sb.toString();
    }

    public String getDefaultExtension() {
        if (this.fileExts != null && !this.fileExts.isEmpty()) {
            return this.fileExts.get(0);
        }
        return null;
    }
}

