/*
 * Decompiled with CFR 0.152.
 */
package org.artifactory.api.license;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.artifactory.api.context.ContextHelper;
import org.artifactory.api.license.LicenseInfo;
import org.artifactory.api.security.AuthorizationService;
import org.artifactory.repo.RepoPath;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.jfrog.build.api.Dependency;

@JsonIgnoreProperties(value={"repoPath", "neutral"})
public class ModuleLicenseModel {
    private String id;
    private String md5;
    private String sha1;
    private LicenseInfo license = LicenseInfo.createNotFound();
    private LicenseInfo extractedLicense = LicenseInfo.createNotSearched();
    private Set<String> scopes = Sets.newHashSet();
    private String scopeNames = "";
    private boolean selected;
    private boolean overridable = false;
    private boolean hasConflicts = false;
    private boolean notFound = false;
    private boolean neutral = false;
    private RepoPath repoPath;
    private String repoKey;
    private String path;
    private String displayName;
    List<String> actions = new ArrayList<String>();

    public ModuleLicenseModel() {
    }

    public ModuleLicenseModel(RepoPath repoPath) {
        this.repoPath = repoPath;
        if (repoPath != null) {
            this.addActions(repoPath);
        } else {
            this.repoKey = "";
            this.path = "No path found (externally resolved or deleted/overwritten)";
        }
        this.actions.add("EditLicense");
    }

    private void addActions(RepoPath repoPath) {
        AuthorizationService authService = ContextHelper.get().getAuthorizationService();
        this.repoKey = repoPath.getRepoKey();
        this.path = repoPath.getPath();
        this.actions.add("ChangeLicense");
        if (authService.canRead(repoPath)) {
            this.actions.add("ShowInTree");
            this.actions.add("Download");
        }
    }

    public ModuleLicenseModel(LicenseInfo license, String id, RepoPath repoPath) {
        this.repoPath = repoPath;
        this.license = license;
        this.id = id;
    }

    public static ModuleLicenseModel createNotFoundModel(RepoPath path) {
        ModuleLicenseModel model = new ModuleLicenseModel(path);
        model.extractedLicense = LicenseInfo.createNotFound();
        model.setModelProperties(false);
        return model;
    }

    public void populateFields(Dependency dependency) {
        this.md5 = dependency.getMd5();
        this.sha1 = dependency.getSha1();
        if (StringUtils.isNotBlank((String)dependency.getId())) {
            this.id = dependency.getId();
        }
        if (dependency.getScopes() == null || dependency.getScopes().isEmpty() || dependency.getScopes().contains(null)) {
            this.scopes.add("unspecified");
        } else {
            this.setScopes(dependency.getScopes());
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getMd5() {
        return this.md5;
    }

    public void setMd5(String md5) {
        this.md5 = md5;
    }

    public String getSha1() {
        return this.sha1;
    }

    public void setSha1(String sha1) {
        this.sha1 = sha1;
    }

    public Set<String> getScopes() {
        return this.scopes;
    }

    public void setScopes(Set<String> scopes) {
        this.scopes = scopes;
        this.ScopeForView(scopes);
    }

    private void ScopeForView(Set<String> scopes) {
        if (scopes != null && !scopes.isEmpty()) {
            StringBuilder scopesBuilder = new StringBuilder();
            scopes.forEach(scope -> scopesBuilder.append(scope + " , "));
            String scopeString = scopesBuilder.toString();
            if (scopeString.length() > 0) {
                this.scopeNames = scopeString.substring(0, scopesBuilder.toString().length() - 3);
            }
        }
    }

    public String getScopeNames() {
        return this.scopeNames;
    }

    public LicenseInfo getLicense() {
        return this.license;
    }

    public void setLicense(LicenseInfo license) {
        this.license = license;
    }

    public LicenseInfo getExtractedLicense() {
        return this.extractedLicense;
    }

    public void setExtractedLicense(LicenseInfo extractedLicense) {
        this.extractedLicense = extractedLicense;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public boolean isOverridable() {
        return this.overridable;
    }

    public void setOverridable(boolean overridable) {
        this.overridable = overridable;
    }

    public boolean hasConflicts() {
        return this.hasConflicts;
    }

    public boolean isNotFound() {
        return this.notFound;
    }

    public boolean isNeutral() {
        return this.neutral;
    }

    public void setNeutral(boolean isNeutral) {
        this.neutral = isNeutral;
    }

    public void setModelProperties(boolean canAnnotate) {
        if (this.license == null) {
            this.license = LicenseInfo.createNotFound();
        }
        if (this.extractedLicense == null) {
            this.extractedLicense = LicenseInfo.createNotSearched();
        }
        if (this.license.isNotFound() && this.extractedLicense.isNotFound() || this.license.isNotFound() && this.extractedLicense.isNotSearched()) {
            this.hasConflicts = true;
            this.notFound = true;
            this.actions.remove("EditLicense");
        } else {
            this.overridable = this.hasMismatchingOverridableLicenses() && canAnnotate;
            this.hasConflicts = this.license.isNotFound() || this.hasMismatchingLicenses() || this.license.isFound() && !this.license.isApproved() || this.license.isUnknown();
        }
    }

    private boolean hasMismatchingLicenses() {
        return !this.extractedLicense.isNotSearched() && !this.license.equals(this.extractedLicense);
    }

    public boolean hasMismatchingAutoOverridableLicenses() {
        return this.extractedLicense.isFound() && (this.license.isNotFound() || this.license.equals(LicenseInfo.createEmptyUnknown()) && !this.extractedLicense.equals(LicenseInfo.createEmptyUnknown()));
    }

    private boolean hasMismatchingOverridableLicenses() {
        return this.hasMismatchingLicenses() && this.extractedLicense.isValidLicense();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ModuleLicenseModel that = (ModuleLicenseModel)o;
        if (!this.getId().equals(that.getId())) {
            return false;
        }
        if (!this.license.equals(that.license)) {
            return false;
        }
        if (!this.extractedLicense.equals(that.extractedLicense)) {
            return false;
        }
        return this.getRepoPath() == null || this.getRepoPath().equals(that.getRepoPath());
    }

    public int hashCode() {
        int result = 31 * this.getId().hashCode();
        result = 31 * result + this.license.hashCode();
        result = 31 * result + this.extractedLicense.hashCode();
        if (this.getRepoPath() != null) {
            result = 31 * result + this.getRepoPath().hashCode();
        }
        return result;
    }

    public String getDisplayName() {
        return this.getId();
    }

    public RepoPath getRepoPath() {
        return this.repoPath;
    }

    public void setRepoPath(RepoPath repoPath) {
        this.repoPath = repoPath;
    }

    public String getRepoKey() {
        return this.repoKey;
    }

    public void setRepoKey(String repoKey) {
        this.repoKey = repoKey;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public List<String> getActions() {
        return this.actions;
    }

    public void setActions(List<String> actions) {
        this.actions = actions;
    }
}

