/*
 * Decompiled with CFR 0.152.
 */
package org.artifactory.api.config;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XStreamAlias(value="artifactoryVersion")
public class VersionInfo
implements Serializable,
Comparable<VersionInfo> {
    private static final String SNAPSHOT = "-SNAPSHOT";
    private static final Logger log = LoggerFactory.getLogger(VersionInfo.class);
    private String version;
    private String revision;

    public VersionInfo() {
    }

    public VersionInfo(String version, String revision) {
        this.version = version;
        this.revision = revision;
    }

    public VersionInfo(String version) {
        this.version = version;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getRevision() {
        return this.revision;
    }

    public void setRevision(String revision) {
        this.revision = revision;
    }

    public String toString() {
        return "VersionInfo{version='" + this.version + '\'' + ", revision='" + this.revision + '\'' + '}';
    }

    @Override
    public int compareTo(VersionInfo other) {
        if (other.getVersion().endsWith(SNAPSHOT)) {
            log.debug("Found development {} version, assuming it grader than any other version ...", (Object)other);
            return 1;
        }
        String[] arrLeft = other.getVersion().split("\\.");
        String[] arrRight = this.getVersion().split("\\.");
        for (int i = 0; i < arrLeft.length || i < arrRight.length; ++i) {
            if (i < arrLeft.length && i < arrRight.length) {
                if (Integer.parseInt(arrLeft[i]) < Integer.parseInt(arrRight[i])) {
                    return -1;
                }
                if (Integer.parseInt(arrLeft[i]) <= Integer.parseInt(arrRight[i])) continue;
                return 1;
            }
            if (i < arrLeft.length) {
                if (Integer.parseInt(arrLeft[i]) == 0) continue;
                return 1;
            }
            if (i >= arrRight.length || Integer.parseInt(arrRight[i]) == 0) continue;
            return -1;
        }
        return 0;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof VersionInfo)) {
            return false;
        }
        VersionInfo that = (VersionInfo)other;
        return this.getVersion().equals(that.getVersion()) && this.getRevision().equals(that.getRevision());
    }
}

