/*
 * Decompiled with CFR 0.152.
 */
package org.artifactory.api.config;

import java.beans.ConstructorProperties;
import lombok.Generated;
import org.artifactory.common.ArtifactoryHome;
import org.artifactory.common.crypto.CryptoHelper;
import org.artifactory.descriptor.repo.ProxyDescriptor;
import org.codehaus.jackson.annotate.JsonProperty;

public class ProxyModel {
    private String key;
    private String host;
    private int port;
    private String username;
    private String password;
    @JsonProperty(value="nt_host")
    private String ntHost;
    private String domain;
    @JsonProperty(value="default_proxy")
    private boolean defaultProxy;
    @JsonProperty(value="redirected_to_hosts")
    private String redirectedToHosts;

    public ProxyModel(ProxyDescriptor proxyDescriptor) {
        this.defaultProxy = proxyDescriptor.isDefaultProxy();
        this.domain = proxyDescriptor.getDomain();
        this.host = proxyDescriptor.getHost();
        this.key = proxyDescriptor.getKey();
        this.ntHost = proxyDescriptor.getNtHost();
        this.password = CryptoHelper.decryptIfNeeded((ArtifactoryHome)ArtifactoryHome.get(), (String)proxyDescriptor.getPassword());
        this.port = proxyDescriptor.getPort();
        this.redirectedToHosts = proxyDescriptor.getRedirectedToHosts();
        this.username = proxyDescriptor.getUsername();
    }

    @Generated
    public String getKey() {
        return this.key;
    }

    @Generated
    public String getHost() {
        return this.host;
    }

    @Generated
    public int getPort() {
        return this.port;
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public String getPassword() {
        return this.password;
    }

    @Generated
    public String getNtHost() {
        return this.ntHost;
    }

    @Generated
    public String getDomain() {
        return this.domain;
    }

    @Generated
    public boolean isDefaultProxy() {
        return this.defaultProxy;
    }

    @Generated
    public String getRedirectedToHosts() {
        return this.redirectedToHosts;
    }

    @Generated
    public void setKey(String key) {
        this.key = key;
    }

    @Generated
    public void setHost(String host) {
        this.host = host;
    }

    @Generated
    public void setPort(int port) {
        this.port = port;
    }

    @Generated
    public void setUsername(String username) {
        this.username = username;
    }

    @Generated
    public void setPassword(String password) {
        this.password = password;
    }

    @Generated
    public void setNtHost(String ntHost) {
        this.ntHost = ntHost;
    }

    @Generated
    public void setDomain(String domain) {
        this.domain = domain;
    }

    @Generated
    public void setDefaultProxy(boolean defaultProxy) {
        this.defaultProxy = defaultProxy;
    }

    @Generated
    public void setRedirectedToHosts(String redirectedToHosts) {
        this.redirectedToHosts = redirectedToHosts;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProxyModel)) {
            return false;
        }
        ProxyModel other = (ProxyModel)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$key = this.getKey();
        String other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        if (this.getPort() != other.getPort()) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$ntHost = this.getNtHost();
        String other$ntHost = other.getNtHost();
        if (this$ntHost == null ? other$ntHost != null : !this$ntHost.equals(other$ntHost)) {
            return false;
        }
        String this$domain = this.getDomain();
        String other$domain = other.getDomain();
        if (this$domain == null ? other$domain != null : !this$domain.equals(other$domain)) {
            return false;
        }
        if (this.isDefaultProxy() != other.isDefaultProxy()) {
            return false;
        }
        String this$redirectedToHosts = this.getRedirectedToHosts();
        String other$redirectedToHosts = other.getRedirectedToHosts();
        return !(this$redirectedToHosts == null ? other$redirectedToHosts != null : !this$redirectedToHosts.equals(other$redirectedToHosts));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ProxyModel;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        result = result * 59 + this.getPort();
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $ntHost = this.getNtHost();
        result = result * 59 + ($ntHost == null ? 43 : $ntHost.hashCode());
        String $domain = this.getDomain();
        result = result * 59 + ($domain == null ? 43 : $domain.hashCode());
        result = result * 59 + (this.isDefaultProxy() ? 79 : 97);
        String $redirectedToHosts = this.getRedirectedToHosts();
        result = result * 59 + ($redirectedToHosts == null ? 43 : $redirectedToHosts.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ProxyModel(key=" + this.getKey() + ", host=" + this.getHost() + ", port=" + this.getPort() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", ntHost=" + this.getNtHost() + ", domain=" + this.getDomain() + ", defaultProxy=" + this.isDefaultProxy() + ", redirectedToHosts=" + this.getRedirectedToHosts() + ")";
    }

    @ConstructorProperties(value={"key", "host", "port", "username", "password", "ntHost", "domain", "defaultProxy", "redirectedToHosts"})
    @Generated
    public ProxyModel(String key, String host, int port, String username, String password, String ntHost, String domain, boolean defaultProxy, String redirectedToHosts) {
        this.key = key;
        this.host = host;
        this.port = port;
        this.username = username;
        this.password = password;
        this.ntHost = ntHost;
        this.domain = domain;
        this.defaultProxy = defaultProxy;
        this.redirectedToHosts = redirectedToHosts;
    }

    @Generated
    public ProxyModel() {
    }
}

