/*
 * Decompiled with CFR 0.152.
 */
package org.artifactory.api.config;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.io.File;
import java.util.Date;
import java.util.Set;
import org.artifactory.api.common.ImportExportStatusHolder;
import org.artifactory.api.config.ImportExportSettingsImpl;
import org.artifactory.sapi.common.BaseSettings;
import org.artifactory.sapi.common.ExportSettings;
import org.artifactory.sapi.common.FileExportCallback;
import org.artifactory.sapi.common.FileExportEvent;
import org.artifactory.sapi.common.FileExportInfo;

@XStreamAlias(value="export-settings")
public class ExportSettingsImpl
extends ImportExportSettingsImpl
implements ExportSettings {
    private boolean ignoreRepositoryFilteringRulesOn = false;
    private boolean createArchive = false;
    private Date time;
    private boolean m2Compatible = false;
    private boolean incremental;
    private boolean excludeBuilds;
    private boolean precalculate;
    private boolean excludeArtifactBundles = false;
    private boolean isExcludeBuildInfoRepo = false;
    @XStreamOmitField
    private SetMultimap<FileExportEvent, FileExportCallback> callbacks;
    private File outputFile;

    public ExportSettingsImpl(File baseDir) {
        super(baseDir, new ImportExportStatusHolder());
        this.time = new Date();
        this.callbacks = HashMultimap.create();
    }

    public ExportSettingsImpl(File baseDir, ImportExportStatusHolder statusHolder) {
        super(baseDir, statusHolder);
        this.time = new Date();
        this.callbacks = HashMultimap.create();
    }

    public ExportSettingsImpl(File baseDir, ExportSettings exportSettings) {
        this(baseDir, exportSettings, (ImportExportStatusHolder)exportSettings.getStatusHolder());
    }

    public ExportSettingsImpl(File baseDir, ExportSettings exportSettings, ImportExportStatusHolder statusHolder) {
        super(baseDir, (BaseSettings)exportSettings, statusHolder);
        ExportSettingsImpl settings = (ExportSettingsImpl)exportSettings;
        this.ignoreRepositoryFilteringRulesOn = settings.ignoreRepositoryFilteringRulesOn;
        this.createArchive = settings.createArchive;
        this.time = settings.time;
        this.m2Compatible = settings.m2Compatible;
        this.incremental = settings.incremental;
        this.callbacks = settings.callbacks;
        this.excludeBuilds = settings.excludeBuilds;
        this.precalculate = settings.precalculate;
        this.excludeArtifactBundles = settings.excludeArtifactBundles;
    }

    public boolean isIgnoreRepositoryFilteringRulesOn() {
        return this.ignoreRepositoryFilteringRulesOn;
    }

    public void setIgnoreRepositoryFilteringRulesOn(boolean ignoreRepositoryFilteringRulesOn) {
        this.ignoreRepositoryFilteringRulesOn = ignoreRepositoryFilteringRulesOn;
    }

    public boolean isCreateArchive() {
        return this.createArchive;
    }

    public void setCreateArchive(boolean createArchive) {
        this.createArchive = createArchive;
    }

    public Date getTime() {
        return this.time;
    }

    public void setTime(Date time) {
        this.time = time;
    }

    public boolean isIncremental() {
        return this.incremental;
    }

    public void setIncremental(boolean incremental) {
        this.incremental = incremental;
    }

    public boolean isM2Compatible() {
        return this.m2Compatible;
    }

    public void setM2Compatible(boolean m2Compatible) {
        this.m2Compatible = m2Compatible;
    }

    public void addCallback(FileExportCallback callback) {
        if (this.callbacks == null) {
            this.callbacks = HashMultimap.create();
        }
        for (FileExportEvent event : callback.triggeringEvents()) {
            this.callbacks.put((Object)event, (Object)callback);
        }
    }

    public void executeCallbacks(FileExportInfo info, FileExportEvent event) {
        if (this.callbacks != null && this.callbacks.containsKey((Object)event)) {
            Set triggered = this.callbacks.get((Object)event);
            for (FileExportCallback callback : triggered) {
                callback.callback((ExportSettings)this, info);
            }
        }
    }

    public void cleanCallbacks() {
        if (this.callbacks != null && !this.callbacks.isEmpty()) {
            this.callbacks.values().forEach(FileExportCallback::cleanup);
            this.callbacks.clear();
        }
    }

    public boolean isExcludeBuilds() {
        return this.excludeBuilds;
    }

    public void setExcludeBuilds(boolean excludeBuilds) {
        this.excludeBuilds = excludeBuilds;
    }

    public boolean isExcludeArtifactBundles() {
        return this.excludeArtifactBundles;
    }

    public void setExcludeArtifactBundles(boolean excludeArtifactBundles) {
        this.excludeArtifactBundles = excludeArtifactBundles;
    }

    public boolean isPrecalculate() {
        return this.precalculate;
    }

    public void setPrecalculate(boolean precalculate) {
        this.precalculate = precalculate;
    }

    public File getOutputFile() {
        return this.outputFile;
    }

    public void setOutputFile(File outputFile) {
        this.outputFile = outputFile;
    }

    public boolean isExcludeBuildInfoRepo() {
        return this.isExcludeBuildInfoRepo;
    }

    public void setExcludeBuildInfoRepo(boolean excludeBuildInfoRepo) {
        this.isExcludeBuildInfoRepo = excludeBuildInfoRepo;
    }
}

