/*
 * Decompiled with CFR 0.152.
 */
package org.artifactory.api.common;

import com.google.common.collect.Sets;
import java.util.Set;
import org.artifactory.api.common.BasicStatusHolder;
import org.artifactory.repo.RepoPath;

public class MoveMultiStatusHolder
extends BasicStatusHolder {
    private int artifactsMovedCounter = 0;
    private int foldersMovedCounter = 0;
    private Set<RepoPath> candidatesForMavenMetadataCalculation = Sets.newHashSet();

    public void artifactMoved() {
        ++this.artifactsMovedCounter;
    }

    public void folderMoved() {
        ++this.foldersMovedCounter;
    }

    public void addToMavenMetadataCandidates(RepoPath repoPath) {
        this.candidatesForMavenMetadataCalculation.add(repoPath);
    }

    public int getMovedArtifactsCount() {
        return this.artifactsMovedCounter;
    }

    public int getMovedFoldersCount() {
        return this.foldersMovedCounter;
    }

    public Set<RepoPath> getCandidatesForMavenMetadataCalculation() {
        return this.candidatesForMavenMetadataCalculation;
    }

    @Override
    public void merge(BasicStatusHolder toMerge) {
        super.merge(toMerge);
        if (toMerge instanceof MoveMultiStatusHolder) {
            MoveMultiStatusHolder moveMultiStatusHolder = (MoveMultiStatusHolder)toMerge;
            this.artifactsMovedCounter += moveMultiStatusHolder.getMovedArtifactsCount();
            this.foldersMovedCounter += moveMultiStatusHolder.getMovedFoldersCount();
            this.candidatesForMavenMetadataCalculation.addAll(((MoveMultiStatusHolder)toMerge).getCandidatesForMavenMetadataCalculation());
        }
    }
}

