/*
 * Decompiled with CFR 0.152.
 */
package org.artifactory.api.bintray.distribution.reporting.model;

import com.google.common.collect.Maps;
import com.jfrog.bintray.client.api.details.RepositoryDetails;
import java.util.Collection;
import java.util.Map;
import org.artifactory.api.bintray.BintrayUploadInfo;
import org.artifactory.api.bintray.distribution.reporting.model.BintrayPackageModel;

public class BintrayRepoModel {
    public String repoName;
    public Boolean created;
    public String type;
    public String visibility;
    public Boolean premium;
    public Map<String, BintrayPackageModel> packages = Maps.newHashMap();

    public BintrayRepoModel(BintrayUploadInfo uploadInfo) {
        RepositoryDetails repoDetails = uploadInfo.getRepositoryDetails();
        this.repoName = repoDetails.getName();
        this.type = repoDetails.getType();
        this.premium = repoDetails.getPremium();
        this.visibility = repoDetails.getIsPrivate() != false ? "Private" : "Public";
        this.packages.put(uploadInfo.getPackageDetails().getName(), new BintrayPackageModel(uploadInfo));
    }

    public void merge(BintrayRepoModel bintrayRepoModel) {
        bintrayRepoModel.packages.values().forEach(this::addPackage);
    }

    private void addPackage(BintrayPackageModel bintrayPackage) {
        BintrayPackageModel existingPackage = this.packages.get(bintrayPackage.packageName);
        if (existingPackage == null) {
            this.packages.put(bintrayPackage.packageName, bintrayPackage);
        } else {
            existingPackage.merge(bintrayPackage);
        }
    }

    public String getRepoName() {
        return this.repoName;
    }

    public Boolean getCreated() {
        return this.created;
    }

    public String getType() {
        return this.type;
    }

    public String getVisibility() {
        return this.visibility;
    }

    public Boolean isPremium() {
        return this.premium;
    }

    public Collection<BintrayPackageModel> getPackages() {
        return this.packages.values();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BintrayRepoModel)) {
            return false;
        }
        BintrayRepoModel that = (BintrayRepoModel)o;
        return this.repoName != null ? this.repoName.equals(that.repoName) : that.repoName == null;
    }

    public int hashCode() {
        return this.repoName != null ? this.repoName.hashCode() : 0;
    }
}

