/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.spacelift.process;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.arquillian.spacelift.process.Command;

public class CommandBuilder {
    private String programName;
    private List<String> parameters;

    public CommandBuilder(CharSequence ... command) throws IllegalArgumentException {
        if (command.length < 1) {
            throw new IllegalArgumentException("Command must not be empty");
        }
        this.programName = command[0].toString();
        this.parameters = new ArrayList<String>(command.length);
        this.parameters(Arrays.copyOfRange(command, 1, command.length));
    }

    public CommandBuilder(CharSequence programName) {
        this.programName = programName.toString();
        this.parameters = new ArrayList<String>();
    }

    public CommandBuilder(CommandBuilder builder) {
        if (builder == null) {
            throw new IllegalArgumentException("CommandBuilder must not be null");
        }
        this.programName = builder.programName;
        this.parameters = new ArrayList<String>(builder.parameters);
    }

    public CommandBuilder parameters(List<? extends CharSequence> parameters) {
        for (CharSequence charSequence : parameters) {
            this.parameter(charSequence.toString());
        }
        return this;
    }

    public CommandBuilder parameters(CharSequence ... parameters) {
        return this.parameters(Arrays.asList(parameters));
    }

    public CommandBuilder parameter(CharSequence parameter) {
        if (parameter != null && parameter.length() > 0) {
            this.parameters.add(parameter.toString());
        }
        return this;
    }

    public CommandBuilder splitToParameters(CharSequence sequenceToBeParsed) {
        if (sequenceToBeParsed != null && sequenceToBeParsed.length() > 0) {
            this.parameters(StringUtils.parameterize(sequenceToBeParsed.toString()));
        }
        return this;
    }

    public Command build() {
        return new CommandImpl(this.programName, this.parameters);
    }

    public String toString() {
        return this.build().toString();
    }

    static final class StringUtils {
        StringUtils() {
        }

        public static List<String> parameterize(String stringToBeParsed) {
            String TOKEN = "\"[^\"\\\\]*(?:\\\\.[^\"\\\\]*)*\"|\\S+";
            String QUOTED_TOKEN = "^\"(.*)\"$";
            ArrayList<String> options = new ArrayList<String>();
            if (stringToBeParsed != null && stringToBeParsed.length() != 0) {
                Pattern p = Pattern.compile("\"[^\"\\\\]*(?:\\\\.[^\"\\\\]*)*\"|\\S+", 32);
                Matcher m = p.matcher(stringToBeParsed);
                while (m.find()) {
                    if (m.group().trim().equals("")) continue;
                    options.add(Pattern.compile("^\"(.*)\"$", 32).matcher(m.group().trim()).replaceAll("$1"));
                }
            }
            return options;
        }
    }

    private static class CommandImpl
    implements Command {
        private final String programName;
        private final List<String> parameters;

        public CommandImpl(String programName, List<String> parameters) {
            this.programName = programName;
            this.parameters = new ArrayList<String>(parameters);
        }

        @Override
        public int getNumberOfParameters() {
            return this.parameters.size();
        }

        @Override
        public String getParameter(int i) {
            if (i == 0) {
                return this.getProgramName();
            }
            try {
                return this.parameters.get(i - 1);
            }
            catch (IndexOutOfBoundsException ex) {
                return null;
            }
        }

        @Override
        public String getProgramName() {
            return this.programName;
        }

        @Override
        public List<String> getParameters() {
            return new ArrayList<String>(this.parameters);
        }

        @Override
        public List<String> getFullCommand() {
            ArrayList<String> fullCommand = new ArrayList<String>(this.parameters.size() + 1);
            fullCommand.add(this.programName);
            fullCommand.addAll(this.parameters);
            return fullCommand;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            String delimiter = "";
            for (String s : this.getFullCommand()) {
                sb.append(delimiter);
                if (StringUtils.parameterize(s).size() > 1) {
                    sb.append('\"').append(s).append('\"');
                } else {
                    sb.append(s);
                }
                delimiter = " ";
            }
            return sb.toString();
        }
    }
}

