/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.openshift.impl.client;

import io.fabric8.kubernetes.api.model.v2_2.Container;
import io.fabric8.kubernetes.api.model.v2_2.ContainerPort;
import io.fabric8.kubernetes.api.model.v2_2.Pod;
import io.fabric8.kubernetes.api.model.v2_2.PodCondition;
import io.fabric8.kubernetes.api.model.v2_2.PodStatus;
import io.fabric8.kubernetes.api.model.v2_2.Service;
import io.fabric8.kubernetes.api.model.v2_2.ServicePort;
import io.fabric8.kubernetes.clnt.v2_2.KubernetesClient;
import io.fabric8.kubernetes.clnt.v2_2.KubernetesClientException;
import io.fabric8.kubernetes.clnt.v2_2.Watch;
import io.fabric8.kubernetes.clnt.v2_2.Watcher;
import io.fabric8.kubernetes.clnt.v2_2.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.clnt.v2_2.dsl.PodResource;
import io.fabric8.openshift.api.model.v2_2.Build;
import io.fabric8.openshift.clnt.v2_2.OpenShiftClient;
import io.fabric8.openshift.clnt.v2_2.dsl.BuildResource;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import org.arquillian.cube.spi.Binding;

public final class ResourceUtil {
    public static Pod waitForStart(KubernetesClient kubernetes, Pod resource) throws Exception {
        final AtomicReference holder = new AtomicReference();
        final CountDownLatch latch = new CountDownLatch(1);
        Watcher<Pod> watcher = new Watcher<Pod>(){

            public void eventReceived(Watcher.Action action, Pod pod) {
                switch (action) {
                    case ADDED: 
                    case MODIFIED: {
                        if (pod.getStatus() == null || !ResourceUtil.isRunning(pod.getStatus().getPhase()) || !ResourceUtil.isReady(pod.getStatus())) break;
                        holder.compareAndSet(null, pod);
                        latch.countDown();
                        break;
                    }
                    case DELETED: 
                    case ERROR: {
                        System.err.println("Unexpected action waiting for pod to start: " + action);
                        holder.compareAndSet(null, pod);
                        latch.countDown();
                    }
                }
            }

            public void onClose(KubernetesClientException cause) {
            }
        };
        System.out.print("waiting for pod " + resource.getMetadata().getName() + " ");
        Watch watch = (Watch)((PodResource)((NonNamespaceOperation)kubernetes.pods().inNamespace(resource.getMetadata().getNamespace())).withName(resource.getMetadata().getName())).watch((Object)watcher);
        latch.await();
        watch.close();
        System.out.println(" done!");
        return (Pod)holder.get();
    }

    private static boolean isReady(PodStatus status) {
        for (PodCondition condition : status.getConditions()) {
            if (!"Ready".equalsIgnoreCase(condition.getType()) || !"False".equalsIgnoreCase(condition.getStatus())) continue;
            return false;
        }
        return true;
    }

    public static Build waitForComplete(OpenShiftClient kubernetes, Build resource) throws Exception {
        final AtomicReference holder = new AtomicReference();
        final CountDownLatch latch = new CountDownLatch(1);
        Watcher<Build> watcher = new Watcher<Build>(){

            public void eventReceived(Watcher.Action action, Build build) {
                switch (action) {
                    case ADDED: 
                    case MODIFIED: {
                        if ("New".equals(build.getStatus().getPhase()) || "Pending".equals(build.getStatus().getPhase()) || "Running".equals(build.getStatus().getPhase())) break;
                        holder.compareAndSet(null, build);
                        latch.countDown();
                        break;
                    }
                    case DELETED: 
                    case ERROR: {
                        System.err.println("Unexpected action waiting for pod to start: " + action);
                        holder.compareAndSet(null, build);
                        latch.countDown();
                    }
                }
            }

            public void onClose(KubernetesClientException cause) {
            }
        };
        System.out.print("waiting for build " + resource.getMetadata().getName() + " ");
        Watch watch = (Watch)((BuildResource)((NonNamespaceOperation)kubernetes.builds().inNamespace(resource.getMetadata().getNamespace())).withName(resource.getMetadata().getName())).watch((Object)watcher);
        latch.await();
        watch.close();
        Build build = (Build)holder.get();
        if (ResourceUtil.isFailed(build) || !ResourceUtil.isComplete(build)) {
            System.out.println(" failed!");
            throw new RuntimeException("Build " + build.getMetadata().getName() + " failed. See log");
        }
        System.out.println(" done!");
        return build;
    }

    public static boolean isRunning(Pod resource) throws Exception {
        return ResourceUtil.isRunning(resource.getStatus().getPhase());
    }

    public static boolean isComplete(Build resource) throws Exception {
        return ResourceUtil.isComplete(resource.getStatus().getPhase());
    }

    public static boolean isFailed(Build resource) throws Exception {
        return "Failed".equals(resource.getStatus().getPhase());
    }

    public static boolean isRunning(String phase) {
        return "Running".equals(phase);
    }

    public static boolean isComplete(String phase) {
        return "Complete".equals(phase);
    }

    public static Binding toBinding(Pod pod) {
        Binding binding = null;
        binding = pod.getStatus() != null && pod.getStatus().getHostIP() != null ? new Binding(pod.getStatus().getHostIP()) : new Binding(null);
        for (Container container : pod.getSpec().getContainers()) {
            for (ContainerPort port : container.getPorts()) {
                binding.addPortBinding(port.getContainerPort(), port.getHostPort());
            }
        }
        return binding;
    }

    public static Binding toBinding(Service pod) {
        Binding binding = null;
        binding = pod.getStatus() != null && pod.getSpec().getClusterIP() != null ? new Binding(pod.getSpec().getClusterIP()) : new Binding(null);
        for (ServicePort port : pod.getSpec().getPorts()) {
            binding.addPortBinding(port.getPort(), port.getNodePort());
        }
        return binding;
    }
}

