/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.openshift.impl.client;

import io.fabric8.kubernetes.api.model.v2_2.HasMetadata;
import io.fabric8.kubernetes.api.model.v2_2.Pod;
import io.fabric8.kubernetes.api.model.v2_2.Service;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.arquillian.cube.kubernetes.api.Configuration;
import org.arquillian.cube.openshift.impl.client.CubeOpenShiftConfiguration;
import org.arquillian.cube.openshift.impl.client.OpenShiftClient;
import org.arquillian.cube.openshift.impl.model.BuildablePodCube;
import org.arquillian.cube.openshift.impl.model.ServiceCube;
import org.arquillian.cube.spi.Cube;
import org.arquillian.cube.spi.CubeRegistry;
import org.jboss.arquillian.core.api.Injector;
import org.jboss.arquillian.core.api.annotation.Observes;

public class CubeOpenShiftRegistrar {
    public void register(@Observes OpenShiftClient client, CubeRegistry registry, Configuration conf, Injector injector) {
        if (!(conf instanceof CubeOpenShiftConfiguration)) {
            return;
        }
        CubeOpenShiftConfiguration configuration = (CubeOpenShiftConfiguration)conf;
        if (!this.hasDefinitionStream(configuration)) {
            return;
        }
        for (HasMetadata item : (List)client.getClientExt().load(this.getDefinitionStream(configuration)).get()) {
            if (item instanceof Pod) {
                registry.addCube((Cube)injector.inject((Object)new BuildablePodCube((Pod)item, client, configuration)));
                continue;
            }
            if (!(item instanceof Service)) continue;
            registry.addCube((Cube)injector.inject((Object)new ServiceCube((Service)item, client, configuration)));
        }
    }

    private boolean hasDefinitionStream(CubeOpenShiftConfiguration conf) {
        return conf.getDefinitions() != null || conf.getDefinitionsFile() != null && new File(conf.getDefinitionsFile()).exists();
    }

    private InputStream getDefinitionStream(CubeOpenShiftConfiguration conf) {
        try {
            if (conf.getDefinitions() != null && !conf.getDefinitions().isEmpty()) {
                return new ByteArrayInputStream(conf.getDefinitions().getBytes(StandardCharsets.UTF_8));
            }
            if (conf.getDefinitionsFile() != null && !conf.getDefinitionsFile().isEmpty()) {
                return new FileInputStream(conf.getDefinitionsFile());
            }
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException("No definitions file found at " + conf.getDefinitionsFile());
        }
        throw new IllegalStateException("Neither definitions nor definitionsFile has been configured.");
    }
}

