package org.arquillian.cube.openshift.impl.client;

import java.util.ArrayList;
import java.util.RandomAccess;
import org.arquillian.cube.kubernetes.api.Configuration;
import java.util.Map;
import java.util.List;
import java.util.List;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.AbstractCollection;
import java.util.HashSet;
import java.util.Set;
import java.net.URL;
import java.util.AbstractList;
import java.util.Set;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.AbstractSet;
import java.io.Serializable;
import java.util.Map;
import java.util.Collection;
import io.fabric8.kubernetes.clnt.v2_2.Config;
import org.arquillian.cube.kubernetes.impl.DefaultConfiguration;
import java.util.AbstractMap;
import org.arquillian.cube.kubernetes.impl.DefaultConfigurationFluentImpl;
import io.fabric8.kubernetes.api.builder.v2_2.Visitable;
import io.fabric8.kubernetes.api.builder.v2_2.Visitable;
import org.arquillian.cube.kubernetes.impl.DefaultConfigurationFluent;
import io.fabric8.kubernetes.api.builder.v2_2.BaseFluent;
import io.fabric8.kubernetes.api.builder.v2_2.Fluent;
import io.fabric8.kubernetes.api.builder.v2_2.Builder;
import io.fabric8.kubernetes.api.builder.v2_2.VisitableBuilder;

public class CubeOpenShiftConfigurationBuilder extends CubeOpenShiftConfigurationFluentImpl<CubeOpenShiftConfigurationBuilder> implements VisitableBuilder<CubeOpenShiftConfiguration,CubeOpenShiftConfigurationBuilder>{

     CubeOpenShiftConfigurationFluent<?> fluent;

    public CubeOpenShiftConfigurationBuilder(){
        this.fluent = this;
    }
    public CubeOpenShiftConfigurationBuilder( CubeOpenShiftConfigurationFluent<?> fluent ){
        this.fluent = fluent;
    }
    public CubeOpenShiftConfigurationBuilder( CubeOpenShiftConfigurationFluent<?> fluent , CubeOpenShiftConfiguration instance ){
        this.fluent = fluent; fluent.withSessionId(instance.getSessionId()); fluent.withMasterUrl(instance.getMasterUrl()); fluent.withNamespace(instance.getNamespace()); fluent.withEnvironmentSetupScriptUrl(instance.getEnvironmentSetupScriptUrl()); fluent.withEnvironmentTeardownScriptUrl(instance.getEnvironmentTeardownScriptUrl()); fluent.withEnvironmentConfigUrl(instance.getEnvironmentConfigUrl()); fluent.withEnvironmentConfigAdditionalUrls(instance.getEnvironmentConfigAdditionalUrls()); fluent.withEnvironmentDependencies(instance.getEnvironmentDependencies()); fluent.withNamespaceLazyCreateEnabled(instance.isNamespaceLazyCreateEnabled()); fluent.withNamespaceCleanupEnabled(instance.isNamespaceCleanupEnabled()); fluent.withNamespaceCleanupTimeout(instance.getNamespaceCleanupTimeout()); fluent.withNamespaceCleanupConfirmationEnabled(instance.isNamespaceCleanupConfirmationEnabled()); fluent.withNamespaceDestroyEnabled(instance.isNamespaceDestroyEnabled()); fluent.withNamespaceDestroyTimeout(instance.getNamespaceDestroyTimeout()); fluent.withNamespaceDestroyConfirmationEnabled(instance.isNamespaceDestroyConfirmationEnabled()); fluent.withWaitTimeout(instance.getWaitTimeout()); fluent.withWaitPollInterval(instance.getWaitPollInterval()); fluent.withWaitForServiceList(instance.getWaitForServiceList()); fluent.withAnsiLoggerEnabled(instance.isAnsiLoggerEnabled()); fluent.withEnvironmentInitEnabled(instance.isEnvironmentInitEnabled()); fluent.withKubernetesDomain(instance.getKubernetesDomain()); fluent.withDockerRegistry(instance.getDockerRegistry()); fluent.withKeepAliveGitServer(instance.isKeepAliveGitServer()); fluent.withDefinitions(instance.getDefinitions()); fluent.withDefinitionsFile(instance.getDefinitionsFile()); fluent.withAutoStartContainers(instance.getAutoStartContainers()); fluent.withProxiedContainerPorts(instance.getProxiedContainerPorts()); fluent.withPortForwardBindAddress(instance.getPortForwardBindAddress()); 
    }
    public CubeOpenShiftConfigurationBuilder( CubeOpenShiftConfiguration instance ){
        this.fluent = this; this.withSessionId(instance.getSessionId()); this.withMasterUrl(instance.getMasterUrl()); this.withNamespace(instance.getNamespace()); this.withEnvironmentSetupScriptUrl(instance.getEnvironmentSetupScriptUrl()); this.withEnvironmentTeardownScriptUrl(instance.getEnvironmentTeardownScriptUrl()); this.withEnvironmentConfigUrl(instance.getEnvironmentConfigUrl()); this.withEnvironmentConfigAdditionalUrls(instance.getEnvironmentConfigAdditionalUrls()); this.withEnvironmentDependencies(instance.getEnvironmentDependencies()); this.withNamespaceLazyCreateEnabled(instance.isNamespaceLazyCreateEnabled()); this.withNamespaceCleanupEnabled(instance.isNamespaceCleanupEnabled()); this.withNamespaceCleanupTimeout(instance.getNamespaceCleanupTimeout()); this.withNamespaceCleanupConfirmationEnabled(instance.isNamespaceCleanupConfirmationEnabled()); this.withNamespaceDestroyEnabled(instance.isNamespaceDestroyEnabled()); this.withNamespaceDestroyTimeout(instance.getNamespaceDestroyTimeout()); this.withNamespaceDestroyConfirmationEnabled(instance.isNamespaceDestroyConfirmationEnabled()); this.withWaitTimeout(instance.getWaitTimeout()); this.withWaitPollInterval(instance.getWaitPollInterval()); this.withWaitForServiceList(instance.getWaitForServiceList()); this.withAnsiLoggerEnabled(instance.isAnsiLoggerEnabled()); this.withEnvironmentInitEnabled(instance.isEnvironmentInitEnabled()); this.withKubernetesDomain(instance.getKubernetesDomain()); this.withDockerRegistry(instance.getDockerRegistry()); this.withKeepAliveGitServer(instance.isKeepAliveGitServer()); this.withDefinitions(instance.getDefinitions()); this.withDefinitionsFile(instance.getDefinitionsFile()); this.withAutoStartContainers(instance.getAutoStartContainers()); this.withProxiedContainerPorts(instance.getProxiedContainerPorts()); this.withPortForwardBindAddress(instance.getPortForwardBindAddress()); 
    }

public CubeOpenShiftConfiguration build(){
    CubeOpenShiftConfiguration buildable = new CubeOpenShiftConfiguration(fluent.getSessionId(),fluent.getMasterUrl(),fluent.getNamespace(),fluent.getEnvironmentSetupScriptUrl(),fluent.getEnvironmentTeardownScriptUrl(),fluent.getEnvironmentConfigUrl(),fluent.getEnvironmentConfigAdditionalUrls(),fluent.getEnvironmentDependencies(),fluent.isNamespaceLazyCreateEnabled(),fluent.isNamespaceCleanupEnabled(),fluent.getNamespaceCleanupTimeout(),fluent.isNamespaceCleanupConfirmationEnabled(),fluent.isNamespaceDestroyEnabled(),fluent.getNamespaceDestroyTimeout(),fluent.isNamespaceDestroyConfirmationEnabled(),fluent.getWaitTimeout(),fluent.getWaitPollInterval(),fluent.getWaitForServiceList(),fluent.isAnsiLoggerEnabled(),fluent.isEnvironmentInitEnabled(),fluent.getKubernetesDomain(),fluent.getDockerRegistry(),fluent.isKeepAliveGitServer(),fluent.getDefinitions(),fluent.getDefinitionsFile(),fluent.getAutoStartContainers(),fluent.getProxiedContainerPorts(),fluent.getPortForwardBindAddress());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
CubeOpenShiftConfigurationBuilder that = (CubeOpenShiftConfigurationBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {}


}
    
