/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.openshift.impl.utils;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.logging.Logger;
import org.arquillian.cube.openshift.impl.utils.Checker;
import org.arquillian.cube.openshift.impl.utils.URLChecker;

public class Containers {
    private static final Logger log = Logger.getLogger(Containers.class.getName());
    private static final String[] CONTAINER_CLASSES = new String[]{"org.jboss.arquillian.ce.wildfly.WildFlyCEContainer", "org.jboss.arquillian.ce.template.TemplateCEContainer", "org.jboss.arquillian.ce.web.WebCEContainer"};

    public static boolean isDeployedInCeContainer() {
        ClassLoader cl = Containers.class.getClassLoader();
        for (String containerClass : CONTAINER_CLASSES) {
            try {
                cl.loadClass(containerClass);
                return true;
            }
            catch (Exception exception) {
            }
        }
        return false;
    }

    public static void delay(long startupTimeout, long checkPeriod, Checker checker) throws Exception {
        long timeout;
        log.info(String.format("Applying checker [%s], timeout: %ss, check period: %sms", checker, startupTimeout, checkPeriod));
        for (timeout = startupTimeout * 1000L; timeout > 0L; timeout -= checkPeriod) {
            Thread.sleep(checkPeriod);
            if (!checker.check()) continue;
            log.info(String.format("Checker [%s] is ready.", checker));
            break;
        }
        if (timeout <= 0L) {
            throw new IllegalStateException(String.format("Checker [%s] failed to pass.", checker));
        }
    }

    public static void delayArchiveDeploy(String serverURL, long startupTimeout, long checkPeriod) throws Exception {
        Containers.delayArchiveDeploy(serverURL, startupTimeout, checkPeriod, new URLChecker(){

            @Override
            public boolean check(URL stream) {
                try {
                    URLConnection connection = stream.openConnection();
                    connection.setConnectTimeout(5000);
                    connection.setReadTimeout(10000);
                    InputStream is = connection.getInputStream();
                    Throwable throwable = null;
                    if (is != null) {
                        if (throwable != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        } else {
                            is.close();
                        }
                    }
                    return true;
                }
                catch (FileNotFoundException e) {
                    return true;
                }
                catch (IOException e) {
                    return false;
                }
            }
        });
    }

    public static void delayArchiveDeploy(final String serverURL, long startupTimeout, long checkPeriod, final URLChecker checker) throws Exception {
        if (serverURL == null) {
            throw new IllegalArgumentException("Null server url");
        }
        final URL server = new URL(serverURL);
        log.info(String.format("Pinging server url: %s [%ss]", serverURL, startupTimeout));
        Checker c = new Checker(){

            @Override
            public boolean check() {
                return checker.check(server);
            }

            public String toString() {
                return serverURL;
            }
        };
        Containers.delay(startupTimeout, checkPeriod, c);
    }
}

