/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.openshift.impl.client;

import io.fabric8.kubernetes.api.model.v3_1.HasMetadata;
import io.fabric8.kubernetes.api.model.v3_1.KubernetesList;
import io.fabric8.kubernetes.api.model.v3_1.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.v3_1.KubernetesResource;
import io.fabric8.kubernetes.api.model.v3_1.Pod;
import io.fabric8.kubernetes.api.model.v3_1.PodBuilder;
import io.fabric8.kubernetes.api.model.v3_1.PodFluent;
import io.fabric8.kubernetes.api.model.v3_1.Service;
import io.fabric8.kubernetes.clnt.v3_1.Config;
import io.fabric8.kubernetes.clnt.v3_1.KubernetesClient;
import io.fabric8.kubernetes.clnt.v3_1.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.clnt.v3_1.dsl.PodResource;
import io.fabric8.kubernetes.clnt.v3_1.dsl.Resource;
import io.fabric8.openshift.api.model.v3_1.Build;
import io.fabric8.openshift.api.model.v3_1.BuildConfig;
import io.fabric8.openshift.api.model.v3_1.BuildConfigBuilder;
import io.fabric8.openshift.api.model.v3_1.BuildConfigFluent;
import io.fabric8.openshift.api.model.v3_1.BuildConfigSpecFluent;
import io.fabric8.openshift.api.model.v3_1.BuildOutputFluent;
import io.fabric8.openshift.api.model.v3_1.BuildRequest;
import io.fabric8.openshift.api.model.v3_1.BuildRequestBuilder;
import io.fabric8.openshift.api.model.v3_1.BuildRequestFluent;
import io.fabric8.openshift.api.model.v3_1.BuildSourceFluent;
import io.fabric8.openshift.api.model.v3_1.BuildStrategyFluent;
import io.fabric8.openshift.api.model.v3_1.ImageStream;
import io.fabric8.openshift.api.model.v3_1.ImageStreamBuilder;
import io.fabric8.openshift.api.model.v3_1.ImageStreamFluent;
import io.fabric8.openshift.api.model.v3_1.NamedTagEventList;
import io.fabric8.openshift.api.model.v3_1.TagEvent;
import io.fabric8.openshift.clnt.v3_1.NamespacedOpenShiftClient;
import io.fabric8.openshift.clnt.v3_1.dsl.BuildConfigResource;
import io.fabric8.openshift.clnt.v3_1.dsl.BuildResource;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.arquillian.cube.openshift.impl.client.GitServer;
import org.arquillian.cube.openshift.impl.client.ResourceUtil;
import org.arquillian.cube.openshift.impl.model.Template;

public class OpenShiftClient {
    private String namespace;
    private NamespacedOpenShiftClient kubernetes;
    private GitServer gitserver;
    private boolean keepAliveGitServer;

    public OpenShiftClient(io.fabric8.openshift.clnt.v3_1.OpenShiftClient client, Config config, String namespace, boolean keepAliveGitServer) {
        this.kubernetes = (NamespacedOpenShiftClient)client;
        this.namespace = namespace;
        this.keepAliveGitServer = keepAliveGitServer;
        this.gitserver = new GitServer((io.fabric8.openshift.clnt.v3_1.OpenShiftClient)this.getClient(), config, namespace);
    }

    public List<Exception> clean(ResourceHolder holder) {
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        ArrayList<HasMetadata> resourcesToDelete = new ArrayList<HasMetadata>();
        for (KubernetesResource resource : holder.getResources()) {
            if (!(resource instanceof HasMetadata)) continue;
            resourcesToDelete.add((HasMetadata)resource);
        }
        try {
            this.getClient().lists().delete((Object[])new KubernetesList[]{((KubernetesListBuilder)new KubernetesListBuilder().withItems(resourcesToDelete)).build()});
        }
        catch (Exception e) {
            exceptions.add(e);
        }
        return exceptions;
    }

    public ResourceHolder build(Template<Pod> template) throws Exception {
        ResourceHolder holder = new ResourceHolder();
        Map<String, String> defaultLabels = this.getDefaultLabels();
        if (template.getRefs().size() == 0) {
            Pod service = this.createStartablePod(template, defaultLabels);
            holder.setPod(service);
            return holder;
        }
        for (Template.TemplateImageRef ref : template.getRefs()) {
            URI repoUri = this.gitserver.push(new File(ref.getPath()), ref.getContainerName());
            String runID = ref.getContainerName();
            try {
                ImageStream is = ((ImageStreamBuilder)((ImageStreamFluent.MetadataNested)((ImageStreamFluent.MetadataNested)((ImageStreamFluent.MetadataNested)new ImageStreamBuilder().withNewMetadata().withName(runID)).withNamespace(this.namespace)).withLabels(defaultLabels)).endMetadata()).build();
                is = (ImageStream)this.getClientExt().imageStreams().createOrReplace((Object[])new ImageStream[]{is});
                holder.addResource((KubernetesResource)is);
                BuildConfig config = ((BuildConfigBuilder)((BuildConfigFluent.SpecNested)((BuildConfigSpecFluent.OutputNested)((BuildOutputFluent.ToNested)((BuildOutputFluent.ToNested)((BuildConfigFluent.SpecNested)((BuildConfigSpecFluent.StrategyNested)((BuildStrategyFluent.DockerStrategyNested)((BuildConfigSpecFluent.StrategyNested)((BuildConfigFluent.SpecNested)((BuildConfigSpecFluent.SourceNested)((BuildSourceFluent.GitNested)((BuildSourceFluent.GitNested)((BuildConfigBuilder)((BuildConfigFluent.MetadataNested)((BuildConfigFluent.MetadataNested)((BuildConfigFluent.MetadataNested)new BuildConfigBuilder().withNewMetadata().withName(runID)).withNamespace(this.namespace)).withLabels(defaultLabels)).endMetadata()).withNewSpec().withNewSource().withNewGit().withUri(repoUri.toString())).withRef("master")).endGit()).endSource()).withNewStrategy().withType("Docker")).withNewDockerStrategy().withNoCache(Boolean.valueOf(false))).endDockerStrategy()).endStrategy()).withNewOutput().withNewTo().withKind("ImageStreamTag")).withName(runID + ":latest")).endTo()).endOutput()).endSpec()).build();
                config = (BuildConfig)this.getClientExt().buildConfigs().createOrReplace((Object[])new BuildConfig[]{config});
                holder.addResource((KubernetesResource)config);
                Long lastBuildVersion = config.getStatus().getLastVersion();
                BuildRequest br = ((BuildRequestBuilder)((BuildRequestFluent.MetadataNested)((BuildRequestFluent.MetadataNested)new BuildRequestBuilder().withNewMetadata().withName(config.getMetadata().getName())).withLabels(defaultLabels)).endMetadata()).build();
                ((BuildConfigResource)((NonNamespaceOperation)this.getClientExt().buildConfigs().inNamespace(this.namespace)).withName(runID)).instantiate((Object)br);
                Build build = ResourceUtil.waitForComplete(this.getClientExt(), (Build)((BuildResource)((NonNamespaceOperation)this.getClientExt().builds().inNamespace(this.namespace)).withName(String.format("%s-%d", config.getMetadata().getName(), lastBuildVersion + 1L))).get());
                holder.addResource((KubernetesResource)build);
                is = (ImageStream)((Resource)((NonNamespaceOperation)this.getClientExt().imageStreams().inNamespace(this.namespace)).withName(is.getMetadata().getName())).get();
                String imageRef = ((TagEvent)((NamedTagEventList)is.getStatus().getTags().get(0)).getItems().get(0)).getDockerImageReference();
                template.resolve(ref, imageRef);
                Pod service = this.createStartablePod(template, defaultLabels);
                holder.setPod(service);
            }
            catch (Exception e) {
                holder.setException(e);
            }
        }
        return holder;
    }

    private Pod createStartablePod(Template<Pod> template, Map<String, String> defaultLabels) {
        HashMap<String, String> allLabels = new HashMap<String, String>();
        allLabels.putAll(defaultLabels);
        allLabels.putAll(template.getTarget().getMetadata().getLabels());
        Pod service = ((PodBuilder)((PodBuilder)((PodFluent.MetadataNested)new PodBuilder().withNewMetadataLike(template.getTarget().getMetadata()).withLabels(allLabels)).endMetadata()).withNewSpecLike(template.getTarget().getSpec()).endSpec()).build();
        return service;
    }

    public Pod createAndWait(Pod resource) throws Exception {
        return ResourceUtil.waitForStart((KubernetesClient)this.getClient(), (Pod)((NonNamespaceOperation)this.getClient().pods().inNamespace(this.namespace)).create((Object[])new Pod[]{resource}));
    }

    public Service create(Service resource) throws Exception {
        return (Service)((NonNamespaceOperation)this.getClient().services().inNamespace(this.namespace)).create((Object[])new Service[]{resource});
    }

    public void destroy(Pod resource) throws Exception {
        ((PodResource)((NonNamespaceOperation)this.getClient().pods().inNamespace(this.namespace)).withName(resource.getMetadata().getName())).delete();
    }

    public void destroy(Service resource) throws Exception {
        ((Resource)((NonNamespaceOperation)this.getClient().services().inNamespace(this.namespace)).withName(resource.getMetadata().getName())).delete();
    }

    public Pod update(Pod resource) throws Exception {
        return (Pod)this.getClient().resource((HasMetadata)resource).createOrReplace();
    }

    public void shutdown() throws Exception {
        if (!this.keepAliveGitServer) {
            this.gitserver.shutdown();
        }
    }

    public NamespacedOpenShiftClient getClient() {
        return this.kubernetes;
    }

    public io.fabric8.openshift.clnt.v3_1.OpenShiftClient getClientExt() {
        return this.kubernetes;
    }

    public String getNamespace() {
        return this.namespace;
    }

    private Map<String, String> getDefaultLabels() {
        HashMap<String, String> labels = new HashMap<String, String>();
        labels.put("generatedby", "arquillian");
        return labels;
    }

    public static class ResourceHolder {
        public Pod pod;
        public Set<KubernetesResource> resources;
        private Exception exception;

        public ResourceHolder() {
            this(null);
        }

        public ResourceHolder(Pod pod) {
            this.pod = pod;
            this.resources = new HashSet<KubernetesResource>();
        }

        public Exception getException() {
            return this.exception;
        }

        public void setException(Exception exception) {
            this.exception = exception;
        }

        public void addResource(KubernetesResource resource) {
            this.resources.add(resource);
        }

        public Set<KubernetesResource> getResources() {
            if (this.resources == null) {
                return new HashSet<KubernetesResource>();
            }
            return this.resources;
        }

        public Pod getPod() {
            return this.pod;
        }

        public void setPod(Pod pod) {
            this.pod = pod;
        }
    }
}

