/*
 * Decompiled with CFR 0.152.
 */
package archtree.list.adapter.bindable;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import androidx.annotation.LayoutRes;
import androidx.databinding.DataBindingComponent;
import androidx.databinding.DataBindingUtil;
import androidx.databinding.ViewDataBinding;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.ViewModel;
import androidx.recyclerview.widget.RecyclerView;
import archtree.list.adapter.bindable.BindableLinearLayoutAdapter;
import archtree.list.item.BindableListItem;
import archtree.list.item.DataContextAwareViewHolder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\bH\u0016J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0017\u001a\u00020\bH\u0014J\u0018\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\bH\u0014JY\u0010 \u001a\u00020\u00192\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00100\"2\n\b\u0001\u0010\r\u001a\u0004\u0018\u00010\b2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\bH\u0016\u00a2\u0006\u0002\u0010#R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\tR\u0014\u0010\n\u001a\u00020\b8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0013\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\tR\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Larchtree/list/adapter/bindable/DefaultBindableLinearLayoutAdapter;", "Larchtree/list/adapter/bindable/BindableLinearLayoutAdapter;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "dataBindingComponent", "", "dataBindingComponentKey", "", "Ljava/lang/Integer;", "itemCount", "getItemCount", "()I", "itemLayout", "itemList", "Ljava/util/ArrayList;", "Larchtree/list/item/BindableListItem;", "lifecycleOwner", "Landroidx/lifecycle/LifecycleOwner;", "lifecycleOwnerKey", "viewModel", "Landroidx/lifecycle/ViewModel;", "getType", "position", "onBindViewHolder", "", "viewHolder", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "onCreateViewHolder", "viewGroup", "Landroid/view/ViewGroup;", "viewType", "onUpdate", "list", "", "(Ljava/util/List;Ljava/lang/Integer;Landroidx/lifecycle/ViewModel;Ljava/lang/Object;Ljava/lang/Integer;Landroidx/lifecycle/LifecycleOwner;Ljava/lang/Integer;)V", "archtree-list_release"})
public class DefaultBindableLinearLayoutAdapter
extends BindableLinearLayoutAdapter {
    private final ArrayList<BindableListItem> itemList;
    private int itemLayout;
    private ViewModel viewModel;
    private Object dataBindingComponent;
    private LifecycleOwner lifecycleOwner;
    private Integer dataBindingComponentKey;
    private Integer lifecycleOwnerKey;
    private final Context context;

    @Override
    public void onUpdate(@NotNull List<? extends BindableListItem> list, @LayoutRes @Nullable Integer itemLayout, @Nullable ViewModel viewModel, @Nullable Object dataBindingComponent, @Nullable Integer dataBindingComponentKey, @Nullable LifecycleOwner lifecycleOwner, @Nullable Integer lifecycleOwnerKey) {
        Intrinsics.checkParameterIsNotNull(list, (String)"list");
        Integer n = itemLayout;
        this.itemLayout = n != null ? n : 0;
        this.viewModel = viewModel;
        this.dataBindingComponent = dataBindingComponent;
        this.lifecycleOwner = lifecycleOwner;
        this.dataBindingComponentKey = dataBindingComponentKey;
        this.lifecycleOwnerKey = lifecycleOwnerKey;
        this.itemList.clear();
        this.itemList.addAll((Collection<BindableListItem>)list);
        this.notifyDataSetChanged();
    }

    @Override
    @NotNull
    protected RecyclerView.ViewHolder onCreateViewHolder(@NotNull ViewGroup viewGroup, int viewType) {
        Integer lifecycleKey;
        DataBindingComponent dataBindingComponent;
        int itemLayoutRes;
        Intrinsics.checkParameterIsNotNull((Object)viewGroup, (String)"viewGroup");
        Object object = (BindableListItem)CollectionsKt.firstOrNull((List)this.itemList);
        int n = object != null && (object = object.onDetermineLayoutRes(viewType)) != null ? (Integer)object : (itemLayoutRes = this.itemLayout);
        if (this.dataBindingComponent != null) {
            DataBindingComponent dataBindingComponent2;
            try {
                Object object2 = this.dataBindingComponent;
                if (!(object2 instanceof DataBindingComponent)) {
                    object2 = null;
                }
                dataBindingComponent2 = (DataBindingComponent)object2;
            }
            catch (ClassCastException e) {
                dataBindingComponent2 = null;
            }
            dataBindingComponent = dataBindingComponent2;
        } else {
            dataBindingComponent = null;
        }
        DataBindingComponent realDataBindingComponent = dataBindingComponent;
        ViewDataBinding binding = DataBindingUtil.inflate((LayoutInflater)LayoutInflater.from((Context)this.context), (int)itemLayoutRes, (ViewGroup)viewGroup, (boolean)false, (DataBindingComponent)realDataBindingComponent);
        Integer dataBindingKey = this.dataBindingComponentKey;
        if (dataBindingKey != null) {
            binding.setVariable(dataBindingKey.intValue(), (Object)realDataBindingComponent);
        }
        if ((lifecycleKey = this.lifecycleOwnerKey) != null) {
            binding.setVariable(lifecycleKey.intValue(), (Object)this.lifecycleOwner);
        }
        if (this.lifecycleOwner != null) {
            ViewDataBinding viewDataBinding = binding;
            Intrinsics.checkExpressionValueIsNotNull((Object)viewDataBinding, (String)"binding");
            viewDataBinding.setLifecycleOwner(this.lifecycleOwner);
        }
        ViewDataBinding viewDataBinding = binding;
        Intrinsics.checkExpressionValueIsNotNull((Object)viewDataBinding, (String)"binding");
        return new DataContextAwareViewHolder(viewDataBinding, viewType);
    }

    @Override
    protected void onBindViewHolder(@NotNull RecyclerView.ViewHolder viewHolder, int position) {
        Intrinsics.checkParameterIsNotNull((Object)viewHolder, (String)"viewHolder");
        if (viewHolder instanceof DataContextAwareViewHolder) {
            DataContextAwareViewHolder dataContextAwareViewHolder = (DataContextAwareViewHolder)viewHolder;
            BindableListItem bindableListItem = this.itemList.get(position);
            Intrinsics.checkExpressionValueIsNotNull((Object)bindableListItem, (String)"itemList[position]");
            dataContextAwareViewHolder.onBind(bindableListItem, this.viewModel);
        }
    }

    @Override
    protected int getItemCount() {
        return this.itemList.size();
    }

    @Override
    public int getType(int position) {
        return this.itemList.get(position).getItemViewType();
    }

    public DefaultBindableLinearLayoutAdapter(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.context = context;
        this.itemList = new ArrayList();
    }
}

