/*
 * Decompiled with CFR 0.152.
 */
package archtree.list.adapter.bindable;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import androidx.annotation.LayoutRes;
import androidx.databinding.DataBindingComponent;
import androidx.databinding.DataBindingUtil;
import androidx.databinding.ViewDataBinding;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.ViewModel;
import androidx.recyclerview.widget.DiffUtil;
import androidx.recyclerview.widget.RecyclerView;
import archtree.list.adapter.bindable.BindableRecyclerViewAdapter;
import archtree.list.item.BindableListItem;
import archtree.list.item.DataContextAwareViewHolder;
import archtree.list.util.BindableRecyclerViewDiffCallback;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0014H\u0016J\b\u0010\u001a\u001a\u00020\bH\u0016J\u0018\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\bH\u0016J\u0018\u0010\u001f\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\bH\u0016JW\u0010#\u001a\u00020\u00182\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\r0%2\b\b\u0001\u0010\n\u001a\u00020\b2\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\bH\u0016\u00a2\u0006\u0002\u0010&R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\tR\u000e\u0010\n\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\r0\fj\b\u0012\u0004\u0012\u00020\r`\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0011\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\tR\u0016\u0010\u0012\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00140\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Larchtree/list/adapter/bindable/DefaultBindableRecyclerViewLayoutAdapter;", "Larchtree/list/adapter/bindable/BindableRecyclerViewAdapter;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "dataBindingComponent", "", "dataBindingComponentKey", "", "Ljava/lang/Integer;", "itemLayout", "itemList", "Ljava/util/ArrayList;", "Larchtree/list/item/BindableListItem;", "Lkotlin/collections/ArrayList;", "lifecycleOwner", "Landroidx/lifecycle/LifecycleOwner;", "lifecycleOwnerKey", "recyclerViewRef", "Ljava/lang/ref/WeakReference;", "Landroidx/recyclerview/widget/RecyclerView;", "viewModel", "Landroidx/lifecycle/ViewModel;", "bindRecyclerView", "", "view", "getItemCount", "onBindViewHolder", "viewHolder", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "position", "onCreateViewHolder", "parent", "Landroid/view/ViewGroup;", "viewType", "onUpdate", "list", "", "(Ljava/util/List;ILandroidx/lifecycle/ViewModel;Ljava/lang/Object;Ljava/lang/Integer;Landroidx/lifecycle/LifecycleOwner;Ljava/lang/Integer;)V", "archtree-list_release"})
public class DefaultBindableRecyclerViewLayoutAdapter
extends BindableRecyclerViewAdapter {
    private ArrayList<BindableListItem> itemList;
    private int itemLayout;
    private ViewModel viewModel;
    private Object dataBindingComponent;
    private LifecycleOwner lifecycleOwner;
    private Integer dataBindingComponentKey;
    private Integer lifecycleOwnerKey;
    private WeakReference<RecyclerView> recyclerViewRef;
    private final Context context;

    @Override
    public void bindRecyclerView(@NotNull RecyclerView view) {
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        this.recyclerViewRef = new WeakReference<RecyclerView>(view);
    }

    @Override
    public void onUpdate(@NotNull List<? extends BindableListItem> list, @LayoutRes int itemLayout, @Nullable ViewModel viewModel, @Nullable Object dataBindingComponent, @Nullable Integer dataBindingComponentKey, @Nullable LifecycleOwner lifecycleOwner, @Nullable Integer lifecycleOwnerKey) {
        Intrinsics.checkParameterIsNotNull(list, (String)"list");
        this.itemLayout = itemLayout;
        this.viewModel = viewModel;
        this.dataBindingComponent = dataBindingComponent;
        this.lifecycleOwner = lifecycleOwner;
        this.dataBindingComponentKey = dataBindingComponentKey;
        this.lifecycleOwnerKey = lifecycleOwnerKey;
        Collection collection = this.itemList;
        boolean bl = false;
        if (!collection.isEmpty()) {
            DiffUtil.DiffResult diffResult = DiffUtil.calculateDiff((DiffUtil.Callback)new BindableRecyclerViewDiffCallback((List<? extends BindableListItem>)this.itemList, list));
            Intrinsics.checkExpressionValueIsNotNull((Object)diffResult, (String)"DiffUtil.calculateDiff(B\u2026ack(this.itemList, list))");
            DiffUtil.DiffResult diffResult2 = diffResult;
            this.itemList.clear();
            this.itemList.addAll((Collection<BindableListItem>)list);
            diffResult2.dispatchUpdatesTo((RecyclerView.Adapter)this);
            RecyclerView recyclerView = (RecyclerView)this.recyclerViewRef.get();
            if (recyclerView != null) {
                recyclerView.scheduleLayoutAnimation();
            }
        } else {
            this.itemList.addAll((Collection<BindableListItem>)list);
        }
    }

    @NotNull
    public RecyclerView.ViewHolder onCreateViewHolder(@NotNull ViewGroup parent, int viewType) {
        Integer lifecycleKey;
        DataBindingComponent dataBindingComponent;
        Intrinsics.checkParameterIsNotNull((Object)parent, (String)"parent");
        if (this.dataBindingComponent != null) {
            DataBindingComponent dataBindingComponent2;
            try {
                Object object = this.dataBindingComponent;
                if (!(object instanceof DataBindingComponent)) {
                    object = null;
                }
                dataBindingComponent2 = (DataBindingComponent)object;
            }
            catch (ClassCastException e) {
                dataBindingComponent2 = null;
            }
            dataBindingComponent = dataBindingComponent2;
        } else {
            dataBindingComponent = null;
        }
        DataBindingComponent realDataBindingComponent = dataBindingComponent;
        ViewDataBinding binding = DataBindingUtil.inflate((LayoutInflater)LayoutInflater.from((Context)this.context), (int)this.itemLayout, (ViewGroup)parent, (boolean)false, (DataBindingComponent)realDataBindingComponent);
        Integer dataBindingKey = this.dataBindingComponentKey;
        if (dataBindingKey != null) {
            binding.setVariable(dataBindingKey.intValue(), (Object)realDataBindingComponent);
        }
        if ((lifecycleKey = this.lifecycleOwnerKey) != null) {
            binding.setVariable(lifecycleKey.intValue(), (Object)this.lifecycleOwner);
        }
        if (this.lifecycleOwner != null) {
            ViewDataBinding viewDataBinding = binding;
            Intrinsics.checkExpressionValueIsNotNull((Object)viewDataBinding, (String)"binding");
            viewDataBinding.setLifecycleOwner(this.lifecycleOwner);
        }
        ViewDataBinding viewDataBinding = binding;
        Intrinsics.checkExpressionValueIsNotNull((Object)viewDataBinding, (String)"binding");
        return new DataContextAwareViewHolder(viewDataBinding);
    }

    public void onBindViewHolder(@NotNull RecyclerView.ViewHolder viewHolder, int position) {
        Intrinsics.checkParameterIsNotNull((Object)viewHolder, (String)"viewHolder");
        if (viewHolder instanceof DataContextAwareViewHolder) {
            DataContextAwareViewHolder dataContextAwareViewHolder = (DataContextAwareViewHolder)viewHolder;
            BindableListItem bindableListItem = this.itemList.get(position);
            Intrinsics.checkExpressionValueIsNotNull((Object)bindableListItem, (String)"itemList[position]");
            dataContextAwareViewHolder.onBind(bindableListItem, this.viewModel);
        }
    }

    public int getItemCount() {
        return this.itemList.size();
    }

    public DefaultBindableRecyclerViewLayoutAdapter(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.context = context;
        this.itemList = new ArrayList();
        this.recyclerViewRef = new WeakReference<Object>(null);
    }
}

