/*
 * Decompiled with CFR 0.152.
 */
package archtree.list.adapter.bindable;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import androidx.databinding.DataBindingComponent;
import androidx.databinding.DataBindingUtil;
import androidx.databinding.ViewDataBinding;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.ViewModel;
import androidx.recyclerview.widget.RecyclerView;
import archtree.list.adapter.bindable.BindableLinearLayoutAdapter;
import archtree.list.item.BindableListItem;
import archtree.list.item.DataContextAwareViewHolder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\bH\u0014J\u0018\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\bH\u0014J<\u0010\u001c\u001a\u00020\u00142\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001e2\u0006\u0010\u000b\u001a\u00020\b2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\b8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Larchtree/list/adapter/bindable/DefaultBindableLinearLayoutAdapter;", "Larchtree/list/adapter/bindable/BindableLinearLayoutAdapter;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "dataBindingComponent", "", "itemCount", "", "getItemCount", "()I", "itemLayout", "itemList", "Ljava/util/ArrayList;", "Larchtree/list/item/BindableListItem;", "lifecycleOwner", "Landroidx/lifecycle/LifecycleOwner;", "viewModel", "Landroidx/lifecycle/ViewModel;", "onBindViewHolder", "", "viewHolder", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "position", "onCreateViewHolder", "viewGroup", "Landroid/view/ViewGroup;", "type", "onUpdate", "list", "", "archtree-list_release"})
public class DefaultBindableLinearLayoutAdapter
extends BindableLinearLayoutAdapter {
    private final ArrayList<BindableListItem> itemList;
    private int itemLayout;
    private ViewModel viewModel;
    private Object dataBindingComponent;
    private LifecycleOwner lifecycleOwner;
    private final Context context;

    @Override
    public void onUpdate(@NotNull List<? extends BindableListItem> list, int itemLayout, @Nullable ViewModel viewModel, @Nullable Object dataBindingComponent, @Nullable LifecycleOwner lifecycleOwner) {
        Intrinsics.checkParameterIsNotNull(list, (String)"list");
        this.itemLayout = itemLayout;
        this.viewModel = viewModel;
        this.dataBindingComponent = dataBindingComponent;
        this.lifecycleOwner = lifecycleOwner;
        this.itemList.clear();
        this.itemList.addAll((Collection<BindableListItem>)list);
        this.notifyDataSetChanged();
    }

    @Override
    @NotNull
    protected RecyclerView.ViewHolder onCreateViewHolder(@NotNull ViewGroup viewGroup, int type) {
        DataBindingComponent dataBindingComponent;
        Intrinsics.checkParameterIsNotNull((Object)viewGroup, (String)"viewGroup");
        if (this.dataBindingComponent != null) {
            DataBindingComponent dataBindingComponent2;
            try {
                Object object = this.dataBindingComponent;
                if (!(object instanceof DataBindingComponent)) {
                    object = null;
                }
                dataBindingComponent2 = (DataBindingComponent)object;
            }
            catch (ClassCastException e) {
                dataBindingComponent2 = null;
            }
            dataBindingComponent = dataBindingComponent2;
        } else {
            dataBindingComponent = null;
        }
        DataBindingComponent realDataBindingComponent = dataBindingComponent;
        ViewDataBinding binding = DataBindingUtil.inflate((LayoutInflater)LayoutInflater.from((Context)this.context), (int)this.itemLayout, (ViewGroup)viewGroup, (boolean)false, (DataBindingComponent)realDataBindingComponent);
        if (this.lifecycleOwner != null) {
            ViewDataBinding viewDataBinding = binding;
            Intrinsics.checkExpressionValueIsNotNull((Object)viewDataBinding, (String)"binding");
            viewDataBinding.setLifecycleOwner(this.lifecycleOwner);
        }
        ViewDataBinding viewDataBinding = binding;
        Intrinsics.checkExpressionValueIsNotNull((Object)viewDataBinding, (String)"binding");
        return new DataContextAwareViewHolder(viewDataBinding);
    }

    @Override
    protected void onBindViewHolder(@NotNull RecyclerView.ViewHolder viewHolder, int position) {
        Intrinsics.checkParameterIsNotNull((Object)viewHolder, (String)"viewHolder");
        if (viewHolder instanceof DataContextAwareViewHolder) {
            DataContextAwareViewHolder dataContextAwareViewHolder = (DataContextAwareViewHolder)viewHolder;
            BindableListItem bindableListItem = this.itemList.get(position);
            Intrinsics.checkExpressionValueIsNotNull((Object)bindableListItem, (String)"itemList[position]");
            dataContextAwareViewHolder.bind(bindableListItem, this.viewModel);
        }
    }

    @Override
    protected int getItemCount() {
        return this.itemList.size();
    }

    public DefaultBindableLinearLayoutAdapter(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.context = context;
        this.itemList = new ArrayList();
    }
}

