/*
 * Decompiled with CFR 0.152.
 */
package org.appfuse.mojo.tasks;

import java.io.File;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.Environment;
import org.apache.tools.ant.types.Path;
import org.appfuse.mojo.appfuse.utility.AntUtilities;
import org.appfuse.mojo.appfuse.utility.FileUtilities;
import org.appfuse.mojo.tasks.GenerationTaskBase;
import org.hibernate.tool.ant.AnnotationConfigurationTask;
import org.hibernate.tool.ant.GenericExporterTask;
import org.hibernate.tool.ant.HibernateToolTask;

public class GeneratePojoTask
extends GenerationTaskBase {
    protected static final String EXPORTER_CLASSNAME = "org.hibernate.tool.hbm2x.POJOExporter";
    private Properties templateProperties;
    private String templateName;
    private String outputFilePattern;
    private String inputFilePattern;
    private String packageName;
    private String hibernateConfigurationFile;

    public void execute() {
        Project antProject = AntUtilities.createProject();
        HibernateToolTask toolTask = new HibernateToolTask();
        toolTask.setProject(antProject);
        toolTask.setDestDir(new File(this.getOutputDirectory()));
        Path newPath = new Path(antProject);
        newPath.setLocation(new File(this.getOuputClassDirectory()));
        toolTask.setClasspath(newPath);
        this.configureAnnotation(toolTask);
        this.configureHbm2Java(toolTask);
        toolTask.execute();
    }

    private void configureHbm2Java(HibernateToolTask inToolTask) {
        GenericExporterTask exporterTask = (GenericExporterTask)inToolTask.createHbmTemplate();
        exporterTask.setExporterClass(EXPORTER_CLASSNAME);
        String packageLocation = FileUtilities.convertPackageNameToFileLocation(this.getPackageName());
        exporterTask.setFilePattern(packageLocation + File.separator + this.getOutputFilePattern());
        exporterTask.setTemplate(this.getTemplateName());
        this.loadProperties(exporterTask, this.getTemplateProperties());
    }

    protected void loadProperties(GenericExporterTask inExporterTask, Properties inProperties) {
        Enumeration<?> names = inProperties.propertyNames();
        while (names.hasMoreElements()) {
            String propertyName = (String)names.nextElement();
            String property = (String)inProperties.get(propertyName);
            Environment.Variable exporterProperty = new Environment.Variable();
            exporterProperty.setKey(propertyName);
            exporterProperty.setValue(property);
            inExporterTask.addConfiguredProperty(exporterProperty);
        }
    }

    private void configureAnnotation(HibernateToolTask inToolTask) {
        AnnotationConfigurationTask annotationConfigurationTask = inToolTask.createAnnotationConfiguration();
        annotationConfigurationTask.setConfigurationFile(new File(this.getHibernateConfigurationFile()));
        annotationConfigurationTask.setProject(inToolTask.getProject());
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public void setTemplateName(String inTemplateName) {
        this.templateName = inTemplateName;
    }

    public Properties getTemplateProperties() {
        return this.templateProperties;
    }

    public void setTemplateProperties(Properties inTemplateProperties) {
        this.templateProperties = inTemplateProperties;
    }

    public String getInputFilePattern() {
        return this.inputFilePattern;
    }

    public void setInputFilePattern(String inInputFilePattern) {
        this.inputFilePattern = inInputFilePattern;
    }

    public String getOutputFilePattern() {
        return this.outputFilePattern;
    }

    public void setOutputFilePattern(String inOutputFilePattern) {
        this.outputFilePattern = inOutputFilePattern;
    }

    public String getHibernateConfigurationFile() {
        return this.hibernateConfigurationFile;
    }

    public void setHibernateConfigurationFile(String inHibernateConfigurationFile) {
        this.hibernateConfigurationFile = inHibernateConfigurationFile;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String inPackageName) {
        this.packageName = inPackageName;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(super.toString());
        buffer.append("GeneratePojoTask[");
        buffer.append("EXPORTER_CLASSNAME = ").append(EXPORTER_CLASSNAME);
        buffer.append("\n hibernateConfigurationFile = ").append(this.hibernateConfigurationFile);
        buffer.append("\n inputFilePattern = ").append(this.inputFilePattern);
        buffer.append("\n outputFilePattern = ").append(this.outputFilePattern);
        buffer.append("\n packageName = ").append(this.packageName);
        buffer.append("\n templateName = ").append(this.templateName);
        buffer.append("\n templateProperties = ").append(this.templateProperties);
        buffer.append("]");
        return buffer.toString();
    }
}

