/*
 * Decompiled with CFR 0.152.
 */
package org.appfuse.mojo.tasks;

import java.io.File;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.Path;
import org.appfuse.mojo.appfuse.utility.AntUtilities;
import org.appfuse.mojo.tasks.GenerationTaskBase;
import org.hibernate.tool.ant.Hbm2CfgXmlExporterTask;
import org.hibernate.tool.ant.Hbm2JavaExporterTask;
import org.hibernate.tool.ant.HibernateToolTask;
import org.hibernate.tool.ant.JDBCConfigurationTask;

public class GenerateModelTask
extends GenerationTaskBase {
    private String reverseEngineeringFile;
    private String databasePropertiesFile;
    private String packageName;
    private boolean generateConfigurationFile;
    private String reverseStrategyClassName;
    private String namingStrategyClassName;
    private String entityResolverClassName;

    public void execute() {
        Project antProject = AntUtilities.createProject();
        HibernateToolTask toolTask = new HibernateToolTask();
        toolTask.setDestDir(new File(this.getOutputDirectory()));
        toolTask.setProject(antProject);
        this.configureJDBC(toolTask);
        this.configureHbmToJava(toolTask);
        if (this.generateConfigurationFile) {
            this.configureHbm2CfgXml(toolTask);
        }
        toolTask.execute();
    }

    private void configureHbm2CfgXml(HibernateToolTask inToolTask) {
        Hbm2CfgXmlExporterTask exporterTask = (Hbm2CfgXmlExporterTask)inToolTask.createHbm2CfgXml();
        exporterTask.setEjb3(this.isEjb3());
    }

    private void configureHbmToJava(HibernateToolTask inToolTask) {
        Hbm2JavaExporterTask exporterTask = (Hbm2JavaExporterTask)inToolTask.createHbm2Java();
        exporterTask.setEjb3(this.isEjb3());
        exporterTask.setJdk5(this.isJdk5());
    }

    private void configureJDBC(HibernateToolTask inToolTask) {
        JDBCConfigurationTask jdbcConfigurationTask = inToolTask.createJDBCConfiguration();
        if (this.getReverseEngineeringFile() != null && this.getReverseEngineeringFile().length() > 0) {
            Path revEngPath = new Path(inToolTask.getProject(), this.getReverseEngineeringFile());
            jdbcConfigurationTask.setRevEngFile(revEngPath);
        }
        if (this.getReverseStrategyClassName() != null && this.getReverseStrategyClassName().length() > 0) {
            jdbcConfigurationTask.setReverseStrategy(this.getReverseStrategyClassName());
        }
        if (this.getNamingStrategyClassName() != null && this.getNamingStrategyClassName().length() > 0) {
            jdbcConfigurationTask.setNamingStrategy(this.getNamingStrategyClassName());
        }
        if (this.getEntityResolverClassName() != null && this.getEntityResolverClassName().length() > 0) {
            jdbcConfigurationTask.setEntityResolver(this.getEntityResolverClassName());
        }
        jdbcConfigurationTask.setPropertyFile(new File(this.getDatabasePropertiesFile()));
        jdbcConfigurationTask.setPackageName(this.getPackageName());
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String inPackageName) {
        this.packageName = inPackageName;
    }

    public String getDatabasePropertiesFile() {
        return this.databasePropertiesFile;
    }

    public void setDatabasePropertiesFile(String inDatabasePropertiesFile) {
        this.databasePropertiesFile = inDatabasePropertiesFile;
    }

    public String getReverseEngineeringFile() {
        return this.reverseEngineeringFile;
    }

    public void setReverseEngineeringFile(String inReverseEngineeringFile) {
        this.reverseEngineeringFile = inReverseEngineeringFile;
    }

    public boolean isGenerateConfigurationFile() {
        return this.generateConfigurationFile;
    }

    public void setGenerateConfigurationFile(boolean inGenerateConfigurationFile) {
        this.generateConfigurationFile = inGenerateConfigurationFile;
    }

    public String getEntityResolverClassName() {
        return this.entityResolverClassName;
    }

    public void setEntityResolverClassName(String inEntityResolverClassName) {
        this.entityResolverClassName = inEntityResolverClassName;
    }

    public String getNamingStrategyClassName() {
        return this.namingStrategyClassName;
    }

    public void setNamingStrategyClassName(String inNamingStrategyClassName) {
        this.namingStrategyClassName = inNamingStrategyClassName;
    }

    public String getReverseStrategyClassName() {
        return this.reverseStrategyClassName;
    }

    public void setReverseStrategyClassName(String inReverseStrategyClassName) {
        this.reverseStrategyClassName = inReverseStrategyClassName;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(super.toString());
        buffer.append("GenerateModelTask[");
        buffer.append("databasePropertiesFile = ").append(this.databasePropertiesFile);
        buffer.append("\n entityResolverClassName = ").append(this.entityResolverClassName);
        buffer.append("\n generateConfigurationFile = ").append(this.generateConfigurationFile);
        buffer.append("\n namingStrategyClassName = ").append(this.namingStrategyClassName);
        buffer.append("\n packageName = ").append(this.packageName);
        buffer.append("\n reverseEngineeringFile = ").append(this.reverseEngineeringFile);
        buffer.append("\n reverseStrategyClassName = ").append(this.reverseStrategyClassName);
        buffer.append("]");
        return buffer.toString();
    }
}

