/*
 * Decompiled with CFR 0.152.
 */
package org.appfuse.mojo.appfuse.mojo.data;

import org.apache.maven.plugin.MojoExecutionException;
import org.appfuse.mojo.MojoBase;
import org.appfuse.mojo.appfuse.utility.FileUtilities;
import org.appfuse.mojo.tasks.GenerateModelTask;
import org.codehaus.plexus.components.interactivity.PrompterException;

public class GenerateModelMojo
extends MojoBase {
    private String databasePropertiesFile;
    private String reverseStrategyClassName;
    private String namingStrategyClassName;
    private String entityResolverClassName;
    private String modelPackageName;
    private String reverseEngineeringConfigurationFile;

    public GenerateModelMojo() {
        this.setMojoName("GenerateModelMojo");
    }

    public void execute() throws MojoExecutionException {
        this.getLog().info((CharSequence)("Running Mojo " + this.getMojoName()));
        boolean copyFiles = false;
        boolean generateConfigFile = false;
        try {
            copyFiles = this.promptForCopy();
            generateConfigFile = this.promptForGenConfig();
        }
        catch (PrompterException ex) {
            throw new MojoExecutionException(ex.getMessage());
        }
        this.getLog().info((CharSequence)("Parameters are " + this.toString()));
        GenerateModelTask task = new GenerateModelTask();
        task.setGenerateConfigurationFile(generateConfigFile);
        task.setEjb3(this.isEjb3());
        task.setJdk5(this.isJdk5());
        task.setReverseEngineeringFile(this.getReverseEngineeringConfigurationFile());
        task.setOutputDirectory(this.getOutputDirectory());
        task.setDatabasePropertiesFile(this.getDatabasePropertiesFile());
        task.setPackageName(this.getModelPackageName());
        task.setEntityResolverClassName(this.getEntityResolverClassName());
        task.setNamingStrategyClassName(this.getNamingStrategyClassName());
        task.setReverseStrategyClassName(this.getReverseStrategyClassName());
        task.execute();
        if (copyFiles) {
            this.getLog().info((CharSequence)"Copying generated files to source tree");
            String pattern = FileUtilities.convertPackageNameToFileLocation(this.modelPackageName) + "**/*.java";
            this.getLog().info((CharSequence)("Copy pattern is " + pattern + " from " + this.getOutputDirectory() + " to " + this.getSourceDirectory()));
            this.copyGeneratedObjects(this.getOutputDirectory(), this.getSourceDirectory(), pattern);
        } else {
            this.getLog().info((CharSequence)"You must copy the generated files to source tree before geneating any additional pojos");
        }
    }

    private boolean promptForCopy() throws PrompterException {
        boolean returnValue = false;
        String copyToSourceTree = this.prompter.prompt("Do you want to copy the generated objects to the source tree (Y/N)");
        if (copyToSourceTree.equalsIgnoreCase("Y")) {
            returnValue = true;
        }
        return returnValue;
    }

    private boolean promptForGenConfig() throws PrompterException {
        boolean returnValue = false;
        String copyToSourceTree = this.prompter.prompt("Do you want to generate a hibernate.cfg.xml file (Y/N)");
        if (copyToSourceTree.equalsIgnoreCase("Y")) {
            returnValue = true;
        }
        return returnValue;
    }

    public String getDatabasePropertiesFile() {
        return this.databasePropertiesFile;
    }

    public void setDatabasePropertiesFile(String inDatabasePropertiesFile) {
        this.databasePropertiesFile = inDatabasePropertiesFile;
    }

    public String getReverseEngineeringConfigurationFile() {
        return this.reverseEngineeringConfigurationFile;
    }

    public void setReverseEngineeringConfigurationFile(String inReverseEngineeringConfigurationFile) {
        this.reverseEngineeringConfigurationFile = inReverseEngineeringConfigurationFile;
    }

    public String getModelPackageName() {
        return this.modelPackageName;
    }

    public void setModelPackageName(String inModelPackageName) {
        this.modelPackageName = inModelPackageName;
    }

    public String getEntityResolverClassName() {
        return this.entityResolverClassName;
    }

    public void setEntityResolverClassName(String inEntityResolverClassName) {
        this.entityResolverClassName = inEntityResolverClassName;
    }

    public String getNamingStrategyClassName() {
        return this.namingStrategyClassName;
    }

    public void setNamingStrategyClassName(String inNamingStrategyClassName) {
        this.namingStrategyClassName = inNamingStrategyClassName;
    }

    public String getReverseStrategyClassName() {
        return this.reverseStrategyClassName;
    }

    public void setReverseStrategyClassName(String inReverseStrategyClassName) {
        this.reverseStrategyClassName = inReverseStrategyClassName;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(super.toString());
        buffer.append("GenerateModelMojo[");
        buffer.append("databasePropertiesFile = ").append(this.databasePropertiesFile);
        buffer.append("\n entityResolverClassName = ").append(this.entityResolverClassName);
        buffer.append("\n modelPackageName = ").append(this.modelPackageName);
        buffer.append("\n namingStrategyClassName = ").append(this.namingStrategyClassName);
        buffer.append("\n reverseEngineeringConfigurationFile = ").append(this.reverseEngineeringConfigurationFile);
        buffer.append("\n reverseStrategyClassName = ").append(this.reverseStrategyClassName);
        buffer.append("]");
        return buffer.toString();
    }
}

