/*
 * Decompiled with CFR 0.152.
 */
package org.appfuse.mojo;

import java.util.Properties;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.MojoExecutionException;
import org.appfuse.mojo.MojoBase;
import org.appfuse.mojo.appfuse.utility.MojoUtilities;
import org.appfuse.mojo.tasks.GeneratePojoTask;
import org.codehaus.plexus.components.interactivity.PrompterException;

public class PojoMojoBase
extends MojoBase {
    private String helperClassName;

    public void execute() throws MojoExecutionException {
        this.getLog().info((CharSequence)("Running Mojo " + this.getMojoName()));
        this.getLog().info((CharSequence)("Parameters are " + this.toString()));
        try {
            GeneratePojoTask task = new GeneratePojoTask();
            Properties props = new Properties();
            this.addProperties(props);
            this.addTaskItems(task, props);
            task.execute();
        }
        catch (DependencyResolutionRequiredException ex) {
            throw new MojoExecutionException(ex.getMessage());
        }
        catch (PrompterException ex) {
            throw new MojoExecutionException(ex.getMessage());
        }
    }

    public void addProperties(Properties inProperties) {
        inProperties.put("modelpackagename", this.getModelPackageName());
        inProperties.put("hibernatetool.helper.toolclass", this.getHelperClassName());
    }

    public void addTaskItems(GeneratePojoTask inTask, Properties inProperties) throws PrompterException, DependencyResolutionRequiredException {
        inTask.setEjb3(this.isEjb3());
        inTask.setJdk5(this.isJdk5());
        inTask.setOutputDirectory(this.getOutputDirectory());
        inTask.setInputFilePattern(this.promptForInputPattern());
        inTask.setModelPackageName(this.getModelPackageName());
        inTask.setTemplateProperties(inProperties);
        inTask.setHibernateConfigurationFile(this.getHibernateConfigurationFile());
        String outputClasspath = MojoUtilities.getOutputClasspath(this.getMavenProject());
        inTask.setOuputClassDirectory(outputClasspath);
    }

    public String getHelperClassName() {
        return this.helperClassName;
    }

    public void setHelperClassName(String inHelperClassName) {
        this.helperClassName = inHelperClassName;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(super.toString());
        buffer.append("PojoMojoBase[");
        buffer.append("helperClassName = ").append(this.helperClassName);
        buffer.append("]");
        return buffer.toString();
    }
}

