/*
 * Decompiled with CFR 0.152.
 */
package org.appfuse.mojo;

import java.io.File;
import java.util.ArrayList;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.types.FileSet;
import org.appfuse.mojo.appfuse.utility.AntUtilities;
import org.codehaus.plexus.components.interactivity.Prompter;
import org.codehaus.plexus.components.interactivity.PrompterException;

public abstract class MojoBase
extends AbstractMojo {
    protected Prompter prompter;
    private MavenProject mavenProject;
    private String sourceDirectory;
    private String mojoName;
    private String outputDirectory;
    private String basePackageName;
    private String modelPackageName;
    private boolean jdk5;
    private boolean ejb3;
    private String hibernateConfigurationFile;

    public abstract void execute() throws MojoExecutionException;

    public String getOutputDirectory() {
        return this.outputDirectory;
    }

    public void setOutputDirectory(String inOutputDirectory) {
        this.outputDirectory = inOutputDirectory;
    }

    public String getMojoName() {
        return this.mojoName;
    }

    public void setMojoName(String inMojoName) {
        this.mojoName = inMojoName;
    }

    public boolean isEjb3() {
        return this.ejb3;
    }

    public void setEjb3(boolean inEjb3) {
        this.ejb3 = inEjb3;
    }

    public boolean isJdk5() {
        return this.jdk5;
    }

    public void setJdk5(boolean inJdk5) {
        this.jdk5 = inJdk5;
    }

    public MavenProject getMavenProject() {
        return this.mavenProject;
    }

    public void setMavenProject(MavenProject inMavenProject) {
        this.mavenProject = inMavenProject;
    }

    public String getModelPackageName() {
        return this.modelPackageName;
    }

    public void setModelPackageName(String inModelPackageName) {
        this.modelPackageName = inModelPackageName;
    }

    public String getHibernateConfigurationFile() {
        return this.hibernateConfigurationFile;
    }

    public void setHibernateConfigurationFile(String inHibernateConfigurationFile) {
        this.hibernateConfigurationFile = inHibernateConfigurationFile;
    }

    public String promptForInputPattern() throws PrompterException {
        String returnValue = this.prompter.prompt("Please enter an Ant Pattern to determine which objects to generate. (Default is **/*.java)");
        return returnValue;
    }

    public String getBasePackageName() {
        return this.basePackageName;
    }

    public void setBasePackageName(String inBasePackageName) {
        this.basePackageName = inBasePackageName;
    }

    protected void copyGeneratedObjects(String inSourceDirectory, String inDestinationDirectory, String inPattern) {
        Project project = AntUtilities.createProject();
        Copy copyTask = (Copy)project.createTask("copy");
        copyTask.init();
        FileSet fileSet = AntUtilities.createFileset(inSourceDirectory, inPattern, new ArrayList());
        this.getLog().info((CharSequence)("Copying files based on pattern " + inPattern + " from directory " + inSourceDirectory));
        copyTask.setTodir(new File(inDestinationDirectory));
        copyTask.addFileset(fileSet);
        copyTask.execute();
    }

    public String getSourceDirectory() {
        return this.sourceDirectory;
    }

    public void setSourceDirectory(String inSourceDirectory) {
        this.sourceDirectory = inSourceDirectory;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("MojoBase[");
        buffer.append("\n ejb3 = ").append(this.ejb3);
        buffer.append("\n jdk5 = ").append(this.jdk5);
        buffer.append("\n mojoName = ").append(this.mojoName);
        buffer.append("\n modelPackageName = ").append(this.modelPackageName);
        buffer.append("\n basePackageName = ").append(this.basePackageName);
        buffer.append("\n outputDirectory = ").append(this.outputDirectory);
        buffer.append("\n sourceDirectory = ").append(this.sourceDirectory);
        buffer.append("\n hibernateConfigurationFile = ").append(this.hibernateConfigurationFile);
        buffer.append("]");
        return buffer.toString();
    }
}

