/*
 * Decompiled with CFR 0.152.
 */
package org.appfuse.dao.hibernate;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.appfuse.dao.GenericDao;
import org.springframework.orm.ObjectRetrievalFailureException;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericDaoHibernate<T, PK extends Serializable>
extends HibernateDaoSupport
implements GenericDao<T, PK> {
    protected final Log log = LogFactory.getLog(this.getClass());
    private Class<T> persistentClass;

    public GenericDaoHibernate(Class<T> persistentClass) {
        this.persistentClass = persistentClass;
    }

    @Override
    public List<T> getAll() {
        return super.getHibernateTemplate().loadAll(this.persistentClass);
    }

    @Override
    public List<T> getAllDistinct() {
        LinkedHashSet<T> result = new LinkedHashSet<T>(this.getAll());
        return new ArrayList<T>(result);
    }

    @Override
    public T get(PK id) {
        Object entity = super.getHibernateTemplate().get(this.persistentClass, id);
        if (entity == null) {
            this.log.warn((Object)("Uh oh, '" + this.persistentClass + "' object with id '" + id + "' not found..."));
            throw new ObjectRetrievalFailureException(this.persistentClass, id);
        }
        return (T)entity;
    }

    @Override
    public boolean exists(PK id) {
        Object entity = super.getHibernateTemplate().get(this.persistentClass, id);
        return entity != null;
    }

    @Override
    public T save(T object) {
        return (T)super.getHibernateTemplate().merge(object);
    }

    @Override
    public void remove(PK id) {
        super.getHibernateTemplate().delete(this.get(id));
    }

    @Override
    public List<T> findByNamedQuery(String queryName, Map<String, Object> queryParams) {
        String[] params = new String[queryParams.size()];
        Object[] values = new Object[queryParams.size()];
        int index = 0;
        Iterator<String> i = queryParams.keySet().iterator();
        while (i.hasNext()) {
            String key;
            params[index] = key = i.next();
            values[index++] = queryParams.get(key);
        }
        return this.getHibernateTemplate().findByNamedQueryAndNamedParam(queryName, params, values);
    }
}

