/*
 * Decompiled with CFR 0.152.
 */
package org.apmem.tools.layouts;

import android.view.View;
import java.util.ArrayList;
import java.util.List;
import org.apmem.tools.layouts.FlowLayout;
import org.apmem.tools.layouts.LayoutConfiguration;
import org.apmem.tools.layouts.ViewContainer;

class LineDefinition {
    private final List<ViewContainer> views = new ArrayList<ViewContainer>();
    private final LayoutConfiguration config;
    private final int maxLength;
    private int lineLength;
    private int lineThickness;
    private int lineLengthWithSpacing;
    private int lineThicknessWithSpacing;
    private int lineStartThickness = 0;
    private int lineStartLength = 0;

    public LineDefinition(int maxLength, LayoutConfiguration config) {
        this.maxLength = maxLength;
        this.config = config;
    }

    public void addView(View child) {
        this.addView(this.views.size(), child);
    }

    public void addView(int i, View child) {
        int spacingThickness;
        int spacingLength;
        int childThickness;
        int childLength;
        int vSpacing;
        FlowLayout.LayoutParams lp = (FlowLayout.LayoutParams)child.getLayoutParams();
        int hSpacing = lp.horizontalSpacingSpecified() ? lp.horizontalSpacing : this.config.getHorizontalSpacing();
        int n = vSpacing = lp.verticalSpacingSpecified() ? lp.verticalSpacing : this.config.getVerticalSpacing();
        if (this.config.getOrientation() == 0) {
            childLength = child.getMeasuredWidth();
            childThickness = child.getMeasuredHeight();
            spacingLength = hSpacing;
            spacingThickness = vSpacing;
        } else {
            childLength = child.getMeasuredHeight();
            childThickness = child.getMeasuredWidth();
            spacingLength = vSpacing;
            spacingThickness = hSpacing;
        }
        ViewContainer container = new ViewContainer(child, spacingLength, spacingThickness);
        container.setLength(childLength);
        container.setThickness(childThickness);
        this.views.add(i, container);
        this.lineLength = this.lineLengthWithSpacing + childLength;
        this.lineLengthWithSpacing = this.lineLength + spacingLength;
        this.lineThicknessWithSpacing = Math.max(this.lineThicknessWithSpacing, childThickness + spacingThickness);
        this.lineThickness = Math.max(this.lineThickness, childThickness);
    }

    public boolean canFit(View child) {
        int childLength = this.config.getOrientation() == 0 ? child.getMeasuredWidth() : child.getMeasuredHeight();
        return this.lineLengthWithSpacing + childLength <= this.maxLength;
    }

    public int getLineStartThickness() {
        return this.lineStartThickness;
    }

    public int getLineThickness() {
        return this.lineThicknessWithSpacing;
    }

    public int getLineLength() {
        return this.lineLength;
    }

    public int getLineStartLength() {
        return this.lineStartLength;
    }

    public List<ViewContainer> getViews() {
        return this.views;
    }

    public void setThickness(int thickness) {
        int thicknessSpacing = this.lineThicknessWithSpacing - this.lineThickness;
        this.lineThicknessWithSpacing = thickness;
        this.lineThickness = thickness - thicknessSpacing;
    }

    public void setLength(int length) {
        int lengthSpacing = this.lineLengthWithSpacing - this.lineLength;
        this.lineLength = length;
        this.lineLengthWithSpacing = length + lengthSpacing;
    }

    public void addLineStartThickness(int extraLineStartThickness) {
        this.lineStartThickness += extraLineStartThickness;
    }

    public void addLineStartLength(int extraLineStartLength) {
        this.lineStartLength += extraLineStartLength;
    }
}

