/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat.samples;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import java.util.concurrent.atomic.AtomicLong;
import org.apfloat.Apfloat;
import org.apfloat.ApfloatContext;
import org.apfloat.ApfloatMath;
import org.apfloat.ApfloatRuntimeException;
import org.apfloat.samples.ApfloatHolder;
import org.apfloat.samples.Operation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Pi {
    protected static PrintWriter out;
    protected static PrintWriter err;
    private static volatile boolean isAlive;

    protected static long getLong(String arg, String name, long minValue, long maxValue) {
        long value = 0L;
        try {
            value = Long.parseLong(arg);
            if (value < minValue || value > maxValue) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException nfe) {
            System.err.println("Invalid " + name + ": " + arg);
            System.exit(1);
        }
        return value;
    }

    protected static int getInt(String arg, String name, int minValue, int maxValue) {
        return (int)Pi.getLong(arg, name, minValue, maxValue);
    }

    protected static long getPrecision(String arg) {
        return Pi.getLong(arg, "digits", 1L, 0x7FFFFFFFFFFFFFFEL);
    }

    protected static int getRadix(String arg) {
        return Pi.getInt(arg, "radix", 2, 36);
    }

    private static void dump() {
        ApfloatContext ctx = ApfloatContext.getContext();
        err.println("builderFactory = " + ctx.getBuilderFactory().getClass().getName());
        err.println("maxMemoryBlockSize = " + ctx.getMaxMemoryBlockSize());
        err.println("cacheL1Size = " + ctx.getCacheL1Size());
        err.println("cacheL2Size = " + ctx.getCacheL2Size());
        err.println("cacheBurst = " + ctx.getCacheBurst());
        err.println("memoryThreshold = " + ctx.getMemoryThreshold());
        err.println("sharedMemoryTreshold = " + ctx.getSharedMemoryTreshold());
        err.println("blockSize = " + ctx.getBlockSize());
        err.println("numberOfProcessors = " + ctx.getNumberOfProcessors());
    }

    public static void run(long precision, int radix, Operation<Apfloat> operation) throws IOException, ApfloatRuntimeException {
        Pi.dump();
        err.println("Calculating pi to " + precision + " radix-" + radix + " digits");
        long time = System.currentTimeMillis();
        Apfloat pi = operation.execute();
        time = System.currentTimeMillis() - time;
        pi.writeTo((Writer)out, true);
        out.println();
        err.println("Total elapsed time " + (double)time / 1000.0 + " seconds");
    }

    public static void setOut(PrintWriter out) {
        Pi.out = out;
    }

    public static PrintWriter getOut() {
        return out;
    }

    public static void setErr(PrintWriter err) {
        Pi.err = err;
    }

    public static PrintWriter getErr() {
        return err;
    }

    public static void setAlive(boolean isAlive) {
        Pi.isAlive = isAlive;
    }

    Pi() {
    }

    public static void main(String[] args) throws IOException, ApfloatRuntimeException {
        Operation<Apfloat> operation;
        if (args.length < 1) {
            System.err.println("USAGE: Pi digits [method] [radix]");
            System.err.println("    method: 0 = Chudnovskys' binsplit");
            System.err.println("            1 = Ramanujan binsplit");
            System.err.println("            2 = Gauss-Legendre");
            System.err.println("            3 = Borweins' quartic");
            System.err.println("    radix must be 2...36");
            return;
        }
        long precision = Pi.getPrecision(args[0]);
        int method = args.length > 1 ? Pi.getInt(args[1], "method", 0, 3) : 0;
        int radix = args.length > 2 ? Pi.getRadix(args[2]) : ApfloatContext.getContext().getDefaultRadix();
        switch (method) {
            case 0: {
                operation = new ChudnovskyPiCalculator(precision, radix);
                break;
            }
            case 1: {
                operation = new RamanujanPiCalculator(precision, radix);
                break;
            }
            case 2: {
                operation = new GaussLegendrePiCalculator(precision, radix);
                break;
            }
            default: {
                operation = new BorweinPiCalculator(precision, radix);
            }
        }
        Pi.setOut(new PrintWriter(System.out, true));
        Pi.setErr(new PrintWriter(System.err, true));
        Pi.run(precision, radix, operation);
    }

    protected static void checkAlive() {
        if (!isAlive) {
            throw new ThreadDeath();
        }
    }

    static {
        isAlive = true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BorweinPiCalculator
    implements Operation<Apfloat> {
        private long precision;
        private int radix;

        public BorweinPiCalculator(long precision, int radix) {
            this.precision = precision;
            this.radix = radix;
        }

        @Override
        public Apfloat execute() {
            err.println("Using the Borweins' quartic iteration");
            int iterations = 0;
            while (BorweinPiCalculator.borweinPrecision(iterations, 4, this.radix) < this.precision) {
                ++iterations;
            }
            err.println("Total " + iterations + " iterations");
            err.printf("Initial values ", new Object[0]);
            long time = System.currentTimeMillis();
            Apfloat one = new Apfloat(1L, this.precision, this.radix);
            Apfloat two = new Apfloat(2L, this.precision, this.radix);
            Apfloat four = new Apfloat(4L, this.precision, this.radix);
            Apfloat y = ApfloatMath.sqrt((Apfloat)two).subtract(one);
            Apfloat a = two.subtract(four.multiply(y));
            time = System.currentTimeMillis() - time;
            err.println("took " + (double)time / 1000.0 + " seconds");
            for (int i = 0; i < iterations; ++i) {
                Pi.checkAlive();
                err.printf("Iteration " + (i + 1) + " ", new Object[0]);
                time = System.currentTimeMillis();
                Apfloat tmp = ApfloatMath.pow((Apfloat)y, (long)4L);
                y = one.subtract(tmp);
                Pi.checkAlive();
                y = ApfloatMath.inverseRoot((Apfloat)y, (long)4L);
                Pi.checkAlive();
                y = y.subtract(one).divide(y.add(one));
                Pi.checkAlive();
                tmp = ApfloatMath.pow((Apfloat)y.add(one), (long)2L);
                Pi.checkAlive();
                a = a.multiply(tmp).multiply(tmp);
                Pi.checkAlive();
                a = a.subtract(new Apfloat(1L << 2 * i + 3, this.precision, this.radix).multiply(y).multiply(tmp.subtract(y)));
                time = System.currentTimeMillis() - time;
                err.println("took " + (double)time / 1000.0 + " seconds");
            }
            Pi.checkAlive();
            err.printf("Final value ", new Object[0]);
            time = System.currentTimeMillis();
            Apfloat pi = one.divide(a);
            time = System.currentTimeMillis() - time;
            err.println("took " + (double)time / 1000.0 + " seconds");
            return pi;
        }

        private static long borweinPrecision(int k, int r, int radix) {
            return (long)((Math.pow(4.0, k) * Math.sqrt(r) * Math.PI - Math.log(16.0 * Math.sqrt(r)) - (double)k * Math.log(4.0)) / Math.log(radix));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class GaussLegendrePiCalculator
    implements Operation<Apfloat> {
        private long precision;
        private int radix;

        public GaussLegendrePiCalculator(long precision, int radix) {
            this.precision = precision;
            this.radix = radix;
        }

        @Override
        public Apfloat execute() {
            err.println("Using the Gauss-Legendre iteration");
            int iterations = 0;
            while (GaussLegendrePiCalculator.gaussLegendrePrecision(iterations, 4, this.radix) < this.precision) {
                ++iterations;
            }
            err.println("Total " + iterations + " iterations");
            err.printf("Initial values ", new Object[0]);
            long time = System.currentTimeMillis();
            Apfloat two = new Apfloat(2L, this.precision, this.radix);
            Apfloat four = new Apfloat(4L, this.precision, this.radix);
            Apfloat a = new Apfloat(1L, this.precision, this.radix);
            Apfloat b = ApfloatMath.inverseRoot((Apfloat)two, (long)2L);
            Apfloat t = a.divide(four);
            time = System.currentTimeMillis() - time;
            err.println("took " + (double)time / 1000.0 + " seconds");
            for (int i = 0; i < iterations; ++i) {
                Pi.checkAlive();
                err.printf("Iteration " + (i + 1) + " ", new Object[0]);
                time = System.currentTimeMillis();
                Apfloat tmp = a;
                a = a.add(b).divide(two);
                Pi.checkAlive();
                b = tmp.multiply(b);
                Pi.checkAlive();
                b = ApfloatMath.sqrt((Apfloat)b);
                Pi.checkAlive();
                t = t.subtract(new Apfloat(1L << i, this.precision, this.radix).multiply(ApfloatMath.pow((Apfloat)tmp.subtract(a), (long)2L)));
                time = System.currentTimeMillis() - time;
                err.println("took " + (double)time / 1000.0 + " seconds");
            }
            Pi.checkAlive();
            err.printf("Final value ", new Object[0]);
            time = System.currentTimeMillis();
            a = a.add(b);
            t = four.multiply(t);
            Apfloat pi = ApfloatMath.pow((Apfloat)a, (long)2L).divide(t);
            time = System.currentTimeMillis() - time;
            err.println("took " + (double)time / 1000.0 + " seconds");
            return pi;
        }

        private static long gaussLegendrePrecision(int k, int r, int radix) {
            return (long)((Math.pow(2.0, k) * Math.sqrt(r) * Math.PI - Math.log(16.0 * Math.sqrt(r)) - (double)k * Math.log(2.0)) / Math.log(radix));
        }
    }

    public static class BinarySplittingProgressIndicator
    implements Serializable {
        private static final long PROGRESS_RECURSION_THRESHOLD = 32L;
        private long totalElements;
        private AtomicLong currentElements;

        public BinarySplittingProgressIndicator(long terms) {
            this.totalElements = (long)((double)terms * (Math.log(terms) / Math.log(2.0) + 1.0)) + 1L;
            this.currentElements = new AtomicLong();
        }

        public void progress(long n1, long n2) {
            int oldPercentComplete;
            long length = n2 - n1;
            if (length < 16L) {
                return;
            }
            long addedElements = length < 32L ? this.recursiveLength(length) : length;
            long oldElements = this.currentElements.getAndAdd(addedElements);
            long elements = oldElements + addedElements;
            int percentComplete = (int)(100L * elements / this.totalElements);
            if (percentComplete != (oldPercentComplete = (int)(100L * oldElements / this.totalElements))) {
                err.printf(percentComplete + "%% complete\r", new Object[0]);
            }
        }

        private long recursiveLength(long length) {
            long recursiveLength;
            if (length == 1L) {
                recursiveLength = 1L;
            } else if (length == 31L) {
                recursiveLength = this.recursiveLength(length >> 1) + length;
            } else {
                long halfLength = length >> 1;
                recursiveLength = this.recursiveLength(halfLength) + this.recursiveLength(length - halfLength) + length;
            }
            return recursiveLength;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RamanujanPiCalculator
    implements Operation<Apfloat> {
        private BinarySplittingPiCalculator calculator;
        private long precision;
        private int radix;

        public RamanujanPiCalculator(long precision, int radix) throws ApfloatRuntimeException {
            this(new BinarySplittingPiCalculator(new RamanujanBinarySplittingSeries(precision, radix)), precision, radix);
        }

        protected RamanujanPiCalculator(BinarySplittingPiCalculator calculator, long precision, int radix) throws ApfloatRuntimeException {
            this.calculator = calculator;
            this.precision = precision;
            this.radix = radix;
        }

        @Override
        public Apfloat execute() {
            err.println("Using the Ramanujan binary splitting algorithm");
            ApfloatHolder T = new ApfloatHolder();
            ApfloatHolder Q = new ApfloatHolder();
            long terms = (long)((double)this.precision * Math.log(this.radix) / 18.38047940053836);
            long time = System.currentTimeMillis();
            this.calculator.r(0L, terms + 1L, T, Q, null, new BinarySplittingProgressIndicator(terms));
            time = System.currentTimeMillis() - time;
            err.println("100% complete, elapsed time " + (double)time / 1000.0 + " seconds");
            err.printf("Final value ", new Object[0]);
            time = System.currentTimeMillis();
            Apfloat t = T.getApfloat();
            Apfloat q = Q.getApfloat();
            Pi.checkAlive();
            Apfloat factor = ApfloatMath.inverseRoot((Apfloat)new Apfloat(8L, this.precision, this.radix), (long)2L);
            Pi.checkAlive();
            Apfloat pi = ApfloatMath.inverseRoot((Apfloat)t, (long)1L).multiply(factor).multiply(new Apfloat(9801L, Long.MAX_VALUE, this.radix)).multiply(q);
            time = System.currentTimeMillis() - time;
            err.println("took " + (double)time / 1000.0 + " seconds");
            return pi;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ChudnovskyPiCalculator
    implements Operation<Apfloat> {
        private BinarySplittingPiCalculator calculator;
        private long precision;
        private int radix;

        public ChudnovskyPiCalculator(long precision, int radix) throws ApfloatRuntimeException {
            this(new BinarySplittingPiCalculator(new ChudnovskyBinarySplittingSeries(precision, radix)), precision, radix);
        }

        protected ChudnovskyPiCalculator(BinarySplittingPiCalculator calculator, long precision, int radix) throws ApfloatRuntimeException {
            this.calculator = calculator;
            this.precision = precision;
            this.radix = radix;
        }

        @Override
        public Apfloat execute() {
            err.println("Using the Chudnovsky brothers' binary splitting algorithm");
            ApfloatHolder T = new ApfloatHolder();
            ApfloatHolder Q = new ApfloatHolder();
            long terms = (long)((double)this.precision * Math.log(this.radix) / 32.65445004176851);
            long time = System.currentTimeMillis();
            this.calculator.r(0L, terms + 1L, T, Q, null, new BinarySplittingProgressIndicator(terms));
            time = System.currentTimeMillis() - time;
            err.println("100% complete, elapsed time " + (double)time / 1000.0 + " seconds");
            err.printf("Final value ", new Object[0]);
            time = System.currentTimeMillis();
            Apfloat t = T.getApfloat();
            Apfloat q = Q.getApfloat();
            Pi.checkAlive();
            Apfloat factor = ApfloatMath.inverseRoot((Apfloat)new Apfloat(640320L, this.precision, this.radix), (long)2L);
            Pi.checkAlive();
            Apfloat pi = ApfloatMath.inverseRoot((Apfloat)factor.multiply(t), (long)1L).multiply(new Apfloat(53360L, Long.MAX_VALUE, this.radix)).multiply(q);
            time = System.currentTimeMillis() - time;
            err.println("took " + (double)time / 1000.0 + " seconds");
            return pi;
        }
    }

    protected static class BinarySplittingPiCalculator
    implements Serializable {
        private BinarySplittingSeries series;

        public BinarySplittingPiCalculator(BinarySplittingSeries series) {
            this.series = series;
        }

        public void r(long n1, long n2, ApfloatHolder T, ApfloatHolder Q, ApfloatHolder P, BinarySplittingProgressIndicator progressIndicator) throws ApfloatRuntimeException {
            Pi.checkAlive();
            assert (n1 != n2);
            long length = n2 - n1;
            if (length == 1L) {
                Apfloat p0 = this.p(n1);
                T.setApfloat(this.a(n1).multiply(p0));
                Q.setApfloat(this.q(n1));
                if (P != null) {
                    P.setApfloat(p0);
                }
            } else {
                long nMiddle = n1 + n2 >> 1;
                ApfloatHolder LT = new ApfloatHolder();
                ApfloatHolder LQ = new ApfloatHolder();
                ApfloatHolder LP = new ApfloatHolder();
                this.r(n1, nMiddle, LT, LQ, LP, progressIndicator);
                this.r(nMiddle, n2, T, Q, P, progressIndicator);
                T.setApfloat(Q.getApfloat().multiply(LT.getApfloat()).add(LP.getApfloat().multiply(T.getApfloat())));
                Q.setApfloat(LQ.getApfloat().multiply(Q.getApfloat()));
                if (P != null) {
                    P.setApfloat(LP.getApfloat().multiply(P.getApfloat()));
                }
            }
            if (progressIndicator != null) {
                progressIndicator.progress(n1, n2);
            }
        }

        private Apfloat a(long n) throws ApfloatRuntimeException {
            return this.series.a(n);
        }

        private Apfloat p(long n) throws ApfloatRuntimeException {
            return this.series.p(n);
        }

        private Apfloat q(long n) throws ApfloatRuntimeException {
            return this.series.q(n);
        }
    }

    protected static class RamanujanBinarySplittingSeries
    extends AbstractBinarySplittingSeries {
        private final Apfloat A;
        private final Apfloat B;
        private final Apfloat J;
        private final Apfloat ONE;
        private final Apfloat TWO;
        private final Apfloat THREE;
        private final Apfloat FOUR;

        public RamanujanBinarySplittingSeries(long precision, int radix) {
            super(precision, radix);
            this.A = new Apfloat(1103L, precision, radix);
            this.B = new Apfloat(26390L, precision, radix);
            this.J = new Apfloat(3073907232L, precision, radix);
            this.ONE = new Apfloat(1L, precision, radix);
            this.TWO = new Apfloat(2L, precision, radix);
            this.THREE = new Apfloat(3L, precision, radix);
            this.FOUR = new Apfloat(4L, precision, radix);
        }

        public Apfloat a(long n) throws ApfloatRuntimeException {
            Apfloat s = new Apfloat(n, Long.MAX_VALUE, this.radix);
            Apfloat v = this.A.add(this.B.multiply(s));
            return v;
        }

        public Apfloat p(long n) throws ApfloatRuntimeException {
            Apfloat v;
            if (n == 0L) {
                v = this.ONE;
            } else {
                Apfloat f = new Apfloat(n, Long.MAX_VALUE, this.radix);
                Apfloat fourf = this.FOUR.multiply(f);
                v = fourf.subtract(this.ONE).multiply(this.TWO.multiply(f).subtract(this.ONE)).multiply(fourf.subtract(this.THREE));
            }
            return v;
        }

        public Apfloat q(long n) throws ApfloatRuntimeException {
            Apfloat v;
            if (n == 0L) {
                v = this.ONE;
            } else {
                Apfloat f = new Apfloat(n, Long.MAX_VALUE, this.radix);
                v = this.J.multiply(f.multiply(f).multiply(f));
            }
            return v;
        }
    }

    protected static class ChudnovskyBinarySplittingSeries
    extends AbstractBinarySplittingSeries {
        private final Apfloat A;
        private final Apfloat B;
        private final Apfloat J;
        private final Apfloat ONE;
        private final Apfloat TWO;
        private final Apfloat FIVE;
        private final Apfloat SIX;

        public ChudnovskyBinarySplittingSeries(long precision, int radix) {
            super(precision, radix);
            this.A = new Apfloat(13591409L, precision, radix);
            this.B = new Apfloat(545140134L, precision, radix);
            this.J = new Apfloat(10939058860032000L, precision, radix);
            this.ONE = new Apfloat(1L, precision, radix);
            this.TWO = new Apfloat(2L, precision, radix);
            this.FIVE = new Apfloat(5L, precision, radix);
            this.SIX = new Apfloat(6L, precision, radix);
        }

        public Apfloat a(long n) throws ApfloatRuntimeException {
            Apfloat s = new Apfloat(n, Long.MAX_VALUE, this.radix);
            Apfloat v = this.A.add(this.B.multiply(s));
            v = (n & 1L) == 0L ? v : v.negate();
            return v;
        }

        public Apfloat p(long n) throws ApfloatRuntimeException {
            Apfloat v;
            if (n == 0L) {
                v = this.ONE;
            } else {
                Apfloat f = new Apfloat(n, Long.MAX_VALUE, this.radix);
                Apfloat sixf = this.SIX.multiply(f);
                v = sixf.subtract(this.ONE).multiply(this.TWO.multiply(f).subtract(this.ONE)).multiply(sixf.subtract(this.FIVE));
            }
            return v;
        }

        public Apfloat q(long n) throws ApfloatRuntimeException {
            Apfloat v;
            if (n == 0L) {
                v = this.ONE;
            } else {
                Apfloat f = new Apfloat(n, Long.MAX_VALUE, this.radix);
                v = this.J.multiply(f.multiply(f).multiply(f));
            }
            return v;
        }
    }

    protected static abstract class AbstractBinarySplittingSeries
    implements BinarySplittingSeries {
        protected long precision;
        protected int radix;

        protected AbstractBinarySplittingSeries(long precision, int radix) {
            this.precision = precision;
            this.radix = radix;
        }
    }

    protected static interface BinarySplittingSeries
    extends Serializable {
        public Apfloat a(long var1) throws ApfloatRuntimeException;

        public Apfloat p(long var1) throws ApfloatRuntimeException;

        public Apfloat q(long var1) throws ApfloatRuntimeException;
    }
}

