/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat.jscience;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Objects;
import java.util.Set;
import javolution.context.LocalContext;
import javolution.lang.Realtime;
import javolution.text.Text;
import org.apfloat.ApfloatArithmeticException;
import org.jscience.mathematics.function.Constant;
import org.jscience.mathematics.function.Polynomial;
import org.jscience.mathematics.function.Term;
import org.jscience.mathematics.function.Variable;
import org.jscience.mathematics.structure.Field;
import org.jscience.mathematics.structure.Ring;

public class ModuloPolynomialField<R extends Field<R>>
implements Field<ModuloPolynomialField<R>>,
Serializable,
Realtime {
    private static final long serialVersionUID = -7690334128073794662L;
    private static final LocalContext.Reference<FiniteFieldPolynomial<? extends Field<?>>> MODULUS = new LocalContext.Reference();
    private static final LocalContext.Reference<FiniteFieldPolynomial<? extends Field<?>>> SCALED_MODULUS = new LocalContext.Reference();
    private static final LocalContext.Reference<FiniteFieldPolynomial<? extends Field<?>>> ZERO = new LocalContext.Reference();
    private static final LocalContext.Reference<FiniteFieldPolynomial<? extends Field<?>>> ONE = new LocalContext.Reference();
    private FiniteFieldPolynomial<R> polynomial;

    public ModuloPolynomialField(Polynomial<R> polynomial) {
        this(new FiniteFieldPolynomial<R>(polynomial));
    }

    private ModuloPolynomialField(FiniteFieldPolynomial<R> polynomial) {
        this.polynomial = ModuloPolynomialField.reduce(polynomial);
    }

    public static <R extends Field<R>> Polynomial<R> getModulus() {
        FiniteFieldPolynomial<R> modulus = ModuloPolynomialField.getModulusInternal();
        return modulus == null ? null : modulus.value();
    }

    private static <R extends Field<R>> FiniteFieldPolynomial<R> getModulusInternal() {
        FiniteFieldPolynomial modulus = (FiniteFieldPolynomial)MODULUS.get();
        return modulus;
    }

    public static <R extends Field<R>> void setModulus(Polynomial<R> modulus) {
        ModuloPolynomialField.setModulus(modulus == null ? null : new FiniteFieldPolynomial<R>(modulus));
    }

    private static <R extends Field<R>> void setModulus(FiniteFieldPolynomial<R> modulus) {
        if (modulus != null) {
            ArrayList<Term> terms = new ArrayList<Term>(modulus.getTerms());
            if (ModuloPolynomialField.getDegree(terms) == 0) {
                throw new IllegalArgumentException("Polynomial must have degree > 0");
            }
            terms.sort(null);
            Term leadingTerm = (Term)terms.get(0);
            R leadingCoefficient = modulus.getCoefficient(leadingTerm);
            if (terms.size() == 1 && ModuloPolynomialField.isZero(leadingCoefficient)) {
                throw new IllegalArgumentException("Polynomial must be nonzero");
            }
            Field inverseLeadingCoefficient = (Field)leadingCoefficient.inverse();
            FiniteFieldPolynomial<Field> scaledModulus = modulus.times(inverseLeadingCoefficient);
            SCALED_MODULUS.set(scaledModulus);
            ZERO.set(new FiniteFieldPolynomial(Constant.valueOf((Ring)((Field)leadingCoefficient.plus((Object)((Field)leadingCoefficient.opposite()))))));
            ONE.set(new FiniteFieldPolynomial(Constant.valueOf((Ring)((Field)leadingCoefficient.times((Object)inverseLeadingCoefficient)))));
        }
        MODULUS.set(modulus);
    }

    public static <R extends Field<R>> Polynomial<R> reduce(Polynomial<R> polynomial) {
        return ModuloPolynomialField.reduce(new FiniteFieldPolynomial<R>(polynomial)).value();
    }

    private static <R extends Field<R>> FiniteFieldPolynomial<R> reduce(FiniteFieldPolynomial<R> polynomial) {
        FiniteFieldPolynomial<R> modulus = ModuloPolynomialField.getModulusInternal();
        if (modulus != null) {
            polynomial = ModuloPolynomialField.div(polynomial, modulus)[1];
        }
        return polynomial;
    }

    private static <R extends Field<R>> FiniteFieldPolynomial<R>[] div(FiniteFieldPolynomial<R> dividend, FiniteFieldPolynomial<R> divisor) {
        int dividendOrder;
        FiniteFieldPolynomial quotient = ModuloPolynomialField.zero();
        FiniteFieldPolynomial<R> remainder = dividend;
        ArrayList<Term> divisorTerms = new ArrayList<Term>(divisor.getTerms());
        int divisorOrder = ModuloPolynomialField.getDegree(divisorTerms);
        divisorTerms.sort(null);
        Term divisorLeadingTerm = (Term)divisorTerms.get(0);
        Field divisorLeadingCoefficientInverse = (Field)divisor.getCoefficient(divisorLeadingTerm).inverse();
        do {
            ArrayList<Term> terms;
            if ((dividendOrder = ModuloPolynomialField.getDegree(terms = new ArrayList<Term>(remainder.getTerms()))) < divisorOrder) continue;
            terms.sort(null);
            Term leadingTerm = (Term)terms.get(0);
            Variable variable = leadingTerm.size() == 0 ? null : leadingTerm.getVariable(0);
            Field coefficient = (Field)remainder.getCoefficient(leadingTerm).times((Object)divisorLeadingCoefficientInverse);
            FiniteFieldPolynomial quotientTerm = new FiniteFieldPolynomial(variable == null ? Constant.valueOf((Ring)coefficient) : Polynomial.valueOf((Ring)coefficient, (Term)Term.valueOf((Variable)variable, (int)(dividendOrder - divisorOrder))));
            quotient = quotient.plus(quotientTerm);
            remainder = remainder.minus(divisor.times(quotientTerm));
        } while (dividendOrder > divisorOrder);
        assert (divisor.times(quotient).plus(remainder).equals(dividend)) : divisor + " * " + quotient + " + " + remainder + " != " + dividend;
        FiniteFieldPolynomial[] qr = new FiniteFieldPolynomial[]{quotient, remainder};
        return qr;
    }

    private static int getDegree(Collection<Term> terms) {
        if (terms.stream().mapToInt(Term::size).anyMatch(i -> i > 1) || terms.stream().filter(t -> t.size() > 0).map(t -> t.getVariable(0)).distinct().count() > 1L) {
            throw new IllegalArgumentException("Polynomial must use a single variable");
        }
        return terms.stream().filter(t -> t.size() > 0).mapToInt(t -> t.getPower(0)).max().orElse(0);
    }

    public ModuloPolynomialField<R> plus(ModuloPolynomialField<R> that) {
        return new ModuloPolynomialField<R>(this.polynomial.plus(that.polynomial));
    }

    public ModuloPolynomialField<R> minus(ModuloPolynomialField<R> that) {
        return new ModuloPolynomialField<R>(this.polynomial.minus(that.polynomial));
    }

    public ModuloPolynomialField<R> opposite() {
        return new ModuloPolynomialField<R>(this.polynomial.opposite());
    }

    public ModuloPolynomialField<R> times(ModuloPolynomialField<R> that) {
        return new ModuloPolynomialField<R>(this.polynomial.times(that.polynomial));
    }

    public ModuloPolynomialField<R> inverse() {
        FiniteFieldPolynomial<R> a = this.polynomial;
        FiniteFieldPolynomial<R> zero = ModuloPolynomialField.zero();
        FiniteFieldPolynomial<R> one = ModuloPolynomialField.one();
        FiniteFieldPolynomial<R> x = zero;
        FiniteFieldPolynomial<Object> oldX = one;
        FiniteFieldPolynomial<R> b = ModuloPolynomialField.getModulusInternal();
        if (b == null) {
            throw new ApfloatArithmeticException("Modulus is not set");
        }
        while (!b.equals(zero)) {
            FiniteFieldPolynomial<R>[] qr = ModuloPolynomialField.div(a, b);
            FiniteFieldPolynomial<R> q = qr[0];
            a = b;
            b = qr[1];
            FiniteFieldPolynomial<R> tmp = x;
            x = oldX.minus(q.times(x));
            oldX = tmp;
        }
        ArrayList<Term> terms = new ArrayList<Term>(a.getTerms());
        if (ModuloPolynomialField.getDegree(terms) != 0) {
            throw new ApfloatArithmeticException("Modular inverse does not exist", "modInverse.notExists", new Object[0]);
        }
        oldX = oldX.times((Field)a.getCoefficient((Term)terms.get(0)).inverse());
        return new ModuloPolynomialField<R>(oldX);
    }

    public Polynomial<R> value() {
        return this.polynomial.value();
    }

    public Object copy() {
        return new ModuloPolynomialField<R>(this.polynomial.value().copy());
    }

    public Text toText() {
        return this.polynomial.value().toText();
    }

    public String toString() {
        return this.toText().toString();
    }

    public int hashCode() {
        return Objects.hashCode(this.polynomial);
    }

    public boolean equals(Object obj) {
        if (obj instanceof ModuloPolynomialField) {
            ModuloPolynomialField that = (ModuloPolynomialField)obj;
            return Objects.equals(this.polynomial, that.polynomial);
        }
        return false;
    }

    private static <R extends Field<R>> boolean isZero(R coefficient) {
        return coefficient.equals(coefficient.opposite());
    }

    private static <R extends Field<R>> FiniteFieldPolynomial<R> zero() {
        FiniteFieldPolynomial zero = (FiniteFieldPolynomial)ZERO.get();
        return zero;
    }

    private static <R extends Field<R>> FiniteFieldPolynomial<R> one() {
        FiniteFieldPolynomial one = (FiniteFieldPolynomial)ONE.get();
        return one;
    }

    private static class FiniteFieldPolynomial<R extends Field<R>> {
        private Polynomial<R> polynomial;

        public FiniteFieldPolynomial(Polynomial<R> polynomial) {
            this.polynomial = FiniteFieldPolynomial.normalize(polynomial);
        }

        public FiniteFieldPolynomial<R> plus(FiniteFieldPolynomial<R> that) {
            return new FiniteFieldPolynomial<R>(this.polynomial.plus(that.polynomial));
        }

        public FiniteFieldPolynomial<R> minus(FiniteFieldPolynomial<R> that) {
            return new FiniteFieldPolynomial<R>(this.polynomial.minus(that.polynomial));
        }

        public FiniteFieldPolynomial<R> opposite() {
            return new FiniteFieldPolynomial<R>(this.polynomial.opposite());
        }

        public FiniteFieldPolynomial<R> times(R that) {
            return new FiniteFieldPolynomial<R>(this.polynomial.times(that));
        }

        public FiniteFieldPolynomial<R> times(FiniteFieldPolynomial<R> that) {
            HashMap<Term, Field> resultTermMap = new HashMap<Term, Field>();
            Field zero = null;
            for (Term t1 : this.polynomial.getTerms()) {
                Field c1 = (Field)this.polynomial.getCoefficient(t1);
                for (Term t2 : that.polynomial.getTerms()) {
                    Field coef;
                    Field c2 = (Field)that.polynomial.getCoefficient(t2);
                    Term t = t1.times(t2);
                    Field c = (Field)c1.times((Object)c2);
                    Field prev = (Field)resultTermMap.get(t);
                    Field field = coef = prev != null ? (Field)prev.plus((Object)c) : c;
                    if (ModuloPolynomialField.isZero(coef)) {
                        zero = coef;
                        resultTermMap.remove(t);
                        continue;
                    }
                    resultTermMap.put(t, coef);
                }
            }
            Polynomial result = resultTermMap.entrySet().stream().map(e -> Polynomial.valueOf((Ring)((Field)e.getValue()), (Term)((Term)e.getKey()))).reduce(Polynomial::plus).orElse((Polynomial)Constant.valueOf(zero));
            return new FiniteFieldPolynomial<R>(result);
        }

        public Set<Term> getTerms() {
            return this.polynomial.getTerms();
        }

        public R getCoefficient(Term term) {
            return (R)((Field)this.polynomial.getCoefficient(term));
        }

        public Polynomial<R> value() {
            return this.polynomial;
        }

        public boolean equals(Object obj) {
            if (obj instanceof FiniteFieldPolynomial) {
                FiniteFieldPolynomial that = (FiniteFieldPolynomial)obj;
                return this.polynomial.equals(that.polynomial);
            }
            return false;
        }

        public int hashCode() {
            return this.polynomial.hashCode() * 3;
        }

        private static <R extends Field<R>> Polynomial<R> normalize(Polynomial<R> polynomial) {
            for (Term term : polynomial.getTerms()) {
                Field coefficient = (Field)polynomial.getCoefficient(term);
                if (term.size() != 0 || !ModuloPolynomialField.isZero(coefficient)) continue;
                return polynomial.plus((Ring)coefficient);
            }
            return polynomial;
        }
    }
}

