/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat.jscience;

import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;
import org.apfloat.Apfloat;
import org.apfloat.ApfloatArithmeticException;
import org.apfloat.Aprational;
import org.apfloat.jscience.AbstractField;

public class AprationalField
extends AbstractField<AprationalField, Aprational> {
    static final XMLFormat<AprationalField> XML = new XMLFormat<AprationalField>(AprationalField.class){

        public AprationalField newInstance(Class<AprationalField> cls, XMLFormat.InputElement xml) throws XMLStreamException {
            return new AprationalField(new Aprational(AbstractField.parse("numerator-", xml).truncate(), AbstractField.parse("denominator-", xml).truncate()));
        }

        public void write(AprationalField field, XMLFormat.OutputElement xml) throws XMLStreamException {
            AbstractField.format((Apfloat)((Aprational)field.value()).numerator(), "numerator-", xml, null);
            AbstractField.format((Apfloat)((Aprational)field.value()).denominator(), "denominator-", xml, null);
        }

        public void read(XMLFormat.InputElement xml, AprationalField field) throws XMLStreamException {
        }
    };
    private static final long serialVersionUID = -4642791345140583865L;

    public AprationalField(Aprational value) {
        super(value);
    }

    @Override
    public AprationalField plus(AprationalField that) {
        return new AprationalField(((Aprational)this.value()).add((Aprational)that.value()));
    }

    @Override
    public AprationalField opposite() {
        return new AprationalField(((Aprational)this.value()).negate());
    }

    @Override
    public AprationalField times(AprationalField that) {
        return new AprationalField(((Aprational)this.value()).multiply((Aprational)that.value()));
    }

    @Override
    public AprationalField inverse() throws ArithmeticException {
        if (((Aprational)this.value()).signum() == 0) {
            throw new ApfloatArithmeticException("Division by zero", "divide.byZero", new Object[0]);
        }
        return new AprationalField(new Aprational(((Aprational)this.value()).denominator(), ((Aprational)this.value()).numerator()));
    }

    @Override
    public AprationalField copy() {
        return new AprationalField((Aprational)this.value());
    }

    @Override
    public boolean isLargerThan(AprationalField that) {
        return ((Aprational)this.value()).multiply((Aprational)this.value()).compareTo(((Aprational)that.value()).multiply((Aprational)that.value())) > 0;
    }
}

