/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat.aparapi;

import org.apfloat.ApfloatRuntimeException;
import org.apfloat.aparapi.ColumnSixStepFNTStrategy;
import org.apfloat.aparapi.LongAparapiFactor3NTTStepStrategy;
import org.apfloat.aparapi.LongAparapiMatrixStrategy;
import org.apfloat.aparapi.LongAparapiNTTStepStrategy;
import org.apfloat.aparapi.LongKernel;
import org.apfloat.internal.ApfloatInternalException;
import org.apfloat.internal.Factor3NTTStrategy;
import org.apfloat.spi.ArrayAccess;
import org.apfloat.spi.DataStorage;
import org.apfloat.spi.NTTStepStrategy;
import org.apfloat.spi.NTTStrategy;

public class LongAparapiFactor3NTTStrategy
extends Factor3NTTStrategy {
    public LongAparapiFactor3NTTStrategy() {
        super((NTTStrategy)new ColumnSixStepFNTStrategy((NTTStepStrategy)new LongAparapiNTTStepStrategy(), new LongAparapiMatrixStrategy()));
        this.stepStrategy = new LongAparapiFactor3NTTStepStrategy();
    }

    public void transform(DataStorage dataStorage, int modulus) throws ApfloatRuntimeException {
        this.preTransform(dataStorage);
        super.transform(dataStorage, modulus);
        this.postTransform(dataStorage);
    }

    public void inverseTransform(DataStorage dataStorage, int modulus, long totalTransformLength) throws ApfloatRuntimeException {
        this.preTransform(dataStorage);
        super.inverseTransform(dataStorage, modulus, totalTransformLength);
        this.postTransform(dataStorage);
    }

    private void preTransform(DataStorage dataStorage) {
        long length = dataStorage.getSize();
        if (length > Integer.MAX_VALUE) {
            throw new ApfloatInternalException("Maximum array length exceeded: " + length);
        }
        ArrayAccess arrayAccess = dataStorage.getArray(3, 0L, (int)length);
        LongKernel kernel = LongKernel.getInstance();
        kernel.setExplicit(true);
        kernel.put(arrayAccess.getLongData());
    }

    private void postTransform(DataStorage dataStorage) {
        long length = dataStorage.getSize();
        assert (length <= Integer.MAX_VALUE);
        ArrayAccess arrayAccess = dataStorage.getArray(3, 0L, (int)length);
        LongKernel kernel = LongKernel.getInstance();
        kernel.get(arrayAccess.getLongData());
        kernel.cleanUpArrays();
    }
}

