/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat.aparapi;

import org.apfloat.ApfloatRuntimeException;
import org.apfloat.internal.ApfloatInternalException;
import org.apfloat.internal.DecorableNTTStrategy;
import org.apfloat.internal.Factor3NTTStrategy;
import org.apfloat.spi.ArrayAccess;
import org.apfloat.spi.DataStorage;
import org.apfloat.spi.Factor3NTTStepStrategy;
import org.apfloat.spi.NTTStrategy;

public class DecorableFactor3NTTStrategy
extends Factor3NTTStrategy
implements DecorableNTTStrategy {
    public DecorableFactor3NTTStrategy(NTTStrategy factor2Strategy) {
        super(factor2Strategy);
    }

    public DecorableFactor3NTTStrategy(NTTStrategy factor2Strategy, Factor3NTTStepStrategy stepStrategy) {
        super(factor2Strategy, stepStrategy);
    }

    public void transform(DataStorage dataStorage, int modulus) throws ApfloatRuntimeException {
        this.preTransform(dataStorage);
        super.transform(dataStorage, modulus);
        this.postTransform(dataStorage);
    }

    public void inverseTransform(DataStorage dataStorage, int modulus, long totalTransformLength) throws ApfloatRuntimeException {
        this.preTransform(dataStorage);
        super.inverseTransform(dataStorage, modulus, totalTransformLength);
        this.postTransform(dataStorage);
    }

    private void preTransform(DataStorage dataStorage) {
        long length = dataStorage.getSize();
        if (length > Integer.MAX_VALUE) {
            throw new ApfloatInternalException("Maximum array length exceeded: " + length);
        }
        ArrayAccess arrayAccess = dataStorage.getArray(3, 0L, (int)length);
        this.preTransform(arrayAccess);
    }

    private void postTransform(DataStorage dataStorage) {
        long length = dataStorage.getSize();
        assert (length <= Integer.MAX_VALUE);
        ArrayAccess arrayAccess = dataStorage.getArray(3, 0L, (int)length);
        this.postTransform(arrayAccess);
    }
}

