/*
 * Decompiled with CFR 0.152.
 */
package org.aperteworkflow.scripting;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.aperteworkflow.scripting.ScriptProcessor;
import org.aperteworkflow.scripting.ScriptProcessorRegistry;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.ServiceRegistration;
import pl.net.bluesoft.rnd.util.func.Func;
import pl.net.bluesoft.util.lang.StringUtil;

public class ScriptingActivator
implements BundleActivator {
    private ScriptProcessorRegistry registry;
    private ServiceRegistration serviceRegistration;
    private static final Logger logger = Logger.getLogger(ScriptingActivator.class.getName());

    public void start(BundleContext context) throws Exception {
        this.registry = new ScriptProcessorRegistry();
        this.serviceRegistration = context.registerService(ScriptProcessorRegistry.class.getName(), (Object)this.registry, null);
        context.addBundleListener(new BundleListener(){

            public void bundleChanged(BundleEvent event) {
                this.processBundleExtensions(event.getBundle(), event.getType(), ScriptingActivator.this.registry);
            }

            private void processBundleExtensions(Bundle bundle, int state, ScriptProcessorRegistry registry) {
                String scriptCfgs = (String)bundle.getHeaders().get("Script-Processor-Classes");
                if (StringUtil.hasText((String)scriptCfgs)) {
                    String[] names;
                    for (String name : names = scriptCfgs.split(",")) {
                        Class scriptProcessorClass;
                        name = name.trim();
                        if (state == 2) {
                            try {
                                scriptProcessorClass = bundle.loadClass(name);
                                final String finalName = name;
                                registry.registerProcessor(scriptProcessorClass.getSimpleName(), new Func<ScriptProcessor>(){

                                    public ScriptProcessor invoke() {
                                        try {
                                            return (ScriptProcessor)scriptProcessorClass.newInstance();
                                        }
                                        catch (InstantiationException e) {
                                            logger.log(Level.SEVERE, e.getMessage(), e);
                                        }
                                        catch (IllegalAccessException e) {
                                            logger.log(Level.SEVERE, e.getMessage(), e);
                                        }
                                        logger.severe("Cannot register script processor: " + finalName);
                                        return null;
                                    }
                                });
                            }
                            catch (Exception e) {
                                logger.log(Level.SEVERE, e.getMessage(), e);
                            }
                            continue;
                        }
                        if (state != 16) continue;
                        try {
                            scriptProcessorClass = bundle.loadClass(name);
                            registry.unregisterProcessor(scriptProcessorClass.getSimpleName());
                        }
                        catch (ClassNotFoundException e) {
                            logger.log(Level.SEVERE, e.getMessage(), e);
                            logger.severe("Cannot unregister script processor: " + name);
                        }
                    }
                }
            }
        });
    }

    public void stop(BundleContext context) throws Exception {
        if (this.serviceRegistration != null) {
            this.serviceRegistration.unregister();
        }
    }
}

