/*
 * Decompiled with CFR 0.152.
 */
package org.aperteworkflow.scripting;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.aperteworkflow.scripting.ScriptProcessor;
import pl.net.bluesoft.rnd.util.func.Func;

public class ScriptProcessorRegistry {
    private final Map<String, Func<ScriptProcessor>> processorMap = new HashMap<String, Func<ScriptProcessor>>();

    public Collection<String> getRegisteredProcessors() {
        return this.processorMap.keySet();
    }

    public void registerProcessor(String name, Func<ScriptProcessor> processor) {
        this.processorMap.put(name, processor);
    }

    public void unregisterProcessor(String name) {
        this.processorMap.remove(name);
    }

    public ScriptProcessor getScriptProcessor(String name) {
        if (this.processorMap.get(name) == null) {
            return null;
        }
        ScriptProcessor processor = (ScriptProcessor)this.processorMap.get(name).invoke();
        return processor;
    }
}

