/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.client.proxy;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.concurrent.Future;
import net.spy.memcached.MemcachedClient;
import net.spy.memcached.MemcachedClientIF;
import org.apereo.cas.client.proxy.AbstractEncryptedProxyGrantingTicketStorageImpl;

public final class MemcachedBackedProxyGrantingTicketStorageImpl
extends AbstractEncryptedProxyGrantingTicketStorageImpl {
    private final MemcachedClientIF client;

    public MemcachedBackedProxyGrantingTicketStorageImpl() {
        this(MemcachedBackedProxyGrantingTicketStorageImpl.getHostsFromClassPath());
    }

    private static String[] getHostsFromClassPath() {
        String[] stringArray;
        InputStream inputStream = MemcachedBackedProxyGrantingTicketStorageImpl.class.getResourceAsStream("/cas/casclient_memcached_hosts.txt");
        ArrayList<String> hosts = new ArrayList<String>();
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                hosts.add(line);
            }
            stringArray = hosts.toArray(new String[hosts.size()]);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        reader.close();
        return stringArray;
    }

    public MemcachedBackedProxyGrantingTicketStorageImpl(String[] hostnamesAndPorts) {
        ArrayList<InetSocketAddress> addresses = new ArrayList<InetSocketAddress>();
        for (String hostname : hostnamesAndPorts) {
            String[] hostPort = hostname.split(":");
            addresses.add(new InetSocketAddress(hostPort[0], Integer.parseInt(hostPort[1])));
        }
        try {
            this.client = new MemcachedClient(addresses);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public void saveInternal(String proxyGrantingTicketIou, String proxyGrantingTicket) {
        MemcachedBackedProxyGrantingTicketStorageImpl.handleSynchronousRequest(this.client.add(proxyGrantingTicketIou, 120, (Object)proxyGrantingTicket));
    }

    public String retrieveInternal(String proxyGrantingTicketIou) {
        return (String)this.client.get(proxyGrantingTicketIou);
    }

    public void cleanUp() {
    }

    private static void handleSynchronousRequest(Future<?> f) {
        try {
            f.get();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

