/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas;

import com.google.common.base.Predicate;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.cas.util.logging.LoggingInitialization;
import org.apereo.cas.util.spring.boot.AbstractCasBanner;
import org.apereo.cas.util.spring.boot.DefaultCasBanner;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.reflections.util.FilterBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.Banner;
import org.springframework.boot.context.metrics.buffering.BufferingApplicationStartup;
import org.springframework.core.metrics.ApplicationStartup;
import org.springframework.core.metrics.jfr.FlightRecorderApplicationStartup;

public final class CasEmbeddedContainerUtils {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CasEmbeddedContainerUtils.class);
    private static final int APPLICATION_EVENTS_CAPACITY = 5000;

    public static Optional<LoggingInitialization> getLoggingInitialization() {
        String packageName = CasEmbeddedContainerUtils.class.getPackage().getName();
        Reflections reflections = new Reflections((Configuration)new ConfigurationBuilder().filterInputsBy((Predicate)new FilterBuilder().includePackage(new String[]{packageName})).setUrls(ClasspathHelper.forPackage((String)packageName, (ClassLoader[])new ClassLoader[0])).setScanners(new Scanner[]{new SubTypesScanner(true)}));
        Set subTypes = reflections.getSubTypesOf(LoggingInitialization.class);
        return subTypes.isEmpty() ? Optional.empty() : Optional.of((LoggingInitialization)((Class)subTypes.iterator().next()).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
    }

    public static Banner getCasBannerInstance() {
        String packageName = CasEmbeddedContainerUtils.class.getPackage().getName();
        Reflections reflections = new Reflections((Configuration)new ConfigurationBuilder().filterInputsBy((Predicate)new FilterBuilder().includePackage(new String[]{packageName})).setUrls(ClasspathHelper.forPackage((String)packageName, (ClassLoader[])new ClassLoader[0])).setScanners(new Scanner[]{new SubTypesScanner(true)}));
        Set subTypes = reflections.getSubTypesOf(AbstractCasBanner.class);
        subTypes.remove(DefaultCasBanner.class);
        if (subTypes.isEmpty()) {
            return new DefaultCasBanner();
        }
        try {
            Class clz = (Class)subTypes.iterator().next();
            return (Banner)clz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
            return new DefaultCasBanner();
        }
    }

    public static ApplicationStartup getApplicationStartup() {
        String type = (String)StringUtils.defaultIfBlank((CharSequence)System.getProperty("CAS_APP_STARTUP"), (CharSequence)"default");
        if (StringUtils.equalsIgnoreCase((CharSequence)"jfr", (CharSequence)type)) {
            return new FlightRecorderApplicationStartup();
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)"buffering", (CharSequence)type)) {
            return new BufferingApplicationStartup(5000);
        }
        return ApplicationStartup.DEFAULT;
    }

    @Generated
    private CasEmbeddedContainerUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

