/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow;

import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.adaptive.AdaptiveAuthenticationPolicy;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceAccessStrategyUtils;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.token.authentication.TokenCredential;
import org.apereo.cas.web.TokenRequestExtractor;
import org.apereo.cas.web.flow.actions.AbstractNonInteractiveCredentialsAction;
import org.apereo.cas.web.flow.resolver.CasDelegatingWebflowEventResolver;
import org.apereo.cas.web.flow.resolver.CasWebflowEventResolver;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.execution.RequestContext;

public class TokenAuthenticationAction
extends AbstractNonInteractiveCredentialsAction {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(TokenAuthenticationAction.class);
    private final TokenRequestExtractor tokenRequestExtractor;
    private final ServicesManager servicesManager;

    public TokenAuthenticationAction(CasDelegatingWebflowEventResolver initialAuthenticationAttemptWebflowEventResolver, CasWebflowEventResolver serviceTicketRequestWebflowEventResolver, AdaptiveAuthenticationPolicy adaptiveAuthenticationPolicy, TokenRequestExtractor tokenRequestExtractor, ServicesManager servicesManager) {
        super(initialAuthenticationAttemptWebflowEventResolver, serviceTicketRequestWebflowEventResolver, adaptiveAuthenticationPolicy);
        this.tokenRequestExtractor = tokenRequestExtractor;
        this.servicesManager = servicesManager;
    }

    protected Credential constructCredentialsFromRequest(RequestContext requestContext) {
        HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)requestContext);
        String authTokenValue = this.tokenRequestExtractor.extract(request);
        WebApplicationService service = WebUtils.getService((RequestContext)requestContext);
        if (service != null && StringUtils.isNotBlank((CharSequence)authTokenValue)) {
            try {
                RegisteredService registeredService = this.servicesManager.findServiceBy((Service)service);
                RegisteredServiceAccessStrategyUtils.ensureServiceAccessIsAllowed((Service)service, (RegisteredService)registeredService);
                TokenCredential credential = new TokenCredential(authTokenValue, (Service)service);
                LOGGER.debug("Received token authentication request [{}] ", (Object)credential);
                return credential;
            }
            catch (Exception e) {
                LOGGER.warn(e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }
}

