/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.token.authentication;

import com.nimbusds.jose.Algorithm;
import com.nimbusds.jose.EncryptionMethod;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.util.Base64;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.AuthenticationHandlerExecutionResult;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.handler.PrincipalNameTransformer;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.integration.pac4j.authentication.handler.support.AbstractTokenWrapperAuthenticationHandler;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceProperty;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.services.UnauthorizedServiceException;
import org.apereo.cas.token.authentication.TokenCredential;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.credentials.authenticator.Authenticator;
import org.pac4j.jwt.config.encryption.EncryptionConfiguration;
import org.pac4j.jwt.config.encryption.SecretEncryptionConfiguration;
import org.pac4j.jwt.config.signature.SecretSignatureConfiguration;
import org.pac4j.jwt.config.signature.SignatureConfiguration;
import org.pac4j.jwt.credentials.authenticator.JwtAuthenticator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenAuthenticationHandler
extends AbstractTokenWrapperAuthenticationHandler {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(TokenAuthenticationHandler.class);

    public TokenAuthenticationHandler(String name, ServicesManager servicesManager, PrincipalFactory principalFactory, PrincipalNameTransformer principalNameTransformer, SessionStore sessionStore) {
        super(name, servicesManager, principalFactory, null, principalNameTransformer, sessionStore);
    }

    private static <T extends Algorithm> T findAlgorithmFamily(Set<Algorithm> family, String alg, Class<T> clazz) {
        Optional<Algorithm> result = family.stream().filter(l -> l.getName().equalsIgnoreCase(alg)).findFirst();
        if (result.isPresent()) {
            Algorithm algorithm = result.get();
            if (!clazz.isAssignableFrom(algorithm.getClass())) {
                throw new ClassCastException("Result [" + algorithm + " is of type " + algorithm.getClass() + " when we were expecting " + clazz);
            }
            return (T)algorithm;
        }
        throw new IllegalArgumentException("Unable to find algorithm " + alg);
    }

    private static byte[] getSecretBytes(String secret, boolean secretIsBase64Encoded) {
        return secretIsBase64Encoded ? new Base64(secret).decode() : secret.getBytes(StandardCharsets.UTF_8);
    }

    public AuthenticationHandlerExecutionResult postAuthenticate(Credential credential, AuthenticationHandlerExecutionResult result) {
        TokenCredential tokenCredential = (TokenCredential)credential;
        tokenCredential.setId(result.getPrincipal().getId());
        return super.postAuthenticate(credential, result);
    }

    protected Authenticator getAuthenticator(Credential credential) {
        TokenCredential tokenCredential = (TokenCredential)credential;
        LOGGER.debug("Locating token secret for service [{}]", (Object)tokenCredential.getService());
        RegisteredService service = this.getServicesManager().findServiceBy(tokenCredential.getService());
        String signingSecret = this.getRegisteredServiceJwtSigningSecret(service);
        if (StringUtils.isNotBlank((CharSequence)signingSecret)) {
            return this.buildJwtAuthenticatorFor(service);
        }
        LOGGER.warn("No token signing secret is defined for service [{}]. Ensure [{}] property is defined for service", (Object)service.getServiceId(), (Object)RegisteredServiceProperty.RegisteredServiceProperties.TOKEN_SECRET_SIGNING.getPropertyName());
        return null;
    }

    protected JwtAuthenticator buildJwtAuthenticatorFor(RegisteredService service) {
        JwtAuthenticator jwtAuthenticator = new JwtAuthenticator();
        SecretSignatureConfiguration signingConfig = this.getSecretSignatureConfiguration(service);
        jwtAuthenticator.setSignatureConfiguration((SignatureConfiguration)signingConfig);
        String encryptionSecret = this.getRegisteredServiceJwtEncryptionSecret(service);
        if (StringUtils.isNotBlank((CharSequence)encryptionSecret)) {
            SecretEncryptionConfiguration encConfig = this.getSecretEncryptionConfiguration(service);
            jwtAuthenticator.setEncryptionConfiguration((EncryptionConfiguration)encConfig);
        } else {
            LOGGER.info("No token encryption secret is defined for service [{}]. You may want to use the [{}] property", (Object)service.getServiceId(), (Object)RegisteredServiceProperty.RegisteredServiceProperties.TOKEN_SECRET_ENCRYPTION.getPropertyName());
        }
        return jwtAuthenticator;
    }

    protected String getRegisteredServiceJwtProperty(RegisteredService service, RegisteredServiceProperty.RegisteredServiceProperties propName) {
        if (service == null || !service.getAccessStrategy().isServiceAccessAllowed()) {
            LOGGER.debug("Service is not defined/found or its access is disabled in the registry");
            throw new UnauthorizedServiceException("screen.service.error.message");
        }
        if (propName.isAssignedTo(service)) {
            return propName.getPropertyValue(service).getValue();
        }
        LOGGER.trace("Service [{}] does not define a property [{}] in the registry", (Object)service.getServiceId(), (Object)propName);
        return null;
    }

    protected SecretSignatureConfiguration getSecretSignatureConfiguration(RegisteredService service) {
        String signingSecret = this.getRegisteredServiceJwtSigningSecret(service);
        String serviceSigningAlg = this.getRegisteredServiceJwtProperty(service, RegisteredServiceProperty.RegisteredServiceProperties.TOKEN_SECRET_SIGNING_ALG);
        HashSet<Algorithm> sets = new HashSet<Algorithm>(0);
        sets.addAll((Collection<Algorithm>)JWSAlgorithm.Family.EC);
        sets.addAll((Collection<Algorithm>)JWSAlgorithm.Family.HMAC_SHA);
        sets.addAll((Collection<Algorithm>)JWSAlgorithm.Family.RSA);
        sets.addAll((Collection<Algorithm>)JWSAlgorithm.Family.SIGNATURE);
        String signingSecretAlg = StringUtils.defaultString((String)serviceSigningAlg, (String)JWSAlgorithm.HS256.getName());
        JWSAlgorithm signingAlg = TokenAuthenticationHandler.findAlgorithmFamily(sets, signingSecretAlg, JWSAlgorithm.class);
        byte[] secretBytes = TokenAuthenticationHandler.getSecretBytes(signingSecret, this.areSecretsBase64Encoded(service));
        return new SecretSignatureConfiguration(secretBytes, signingAlg);
    }

    protected SecretEncryptionConfiguration getSecretEncryptionConfiguration(RegisteredService service) {
        String encryptionSecret = this.getRegisteredServiceJwtEncryptionSecret(service);
        HashSet<Algorithm> sets = new HashSet<Algorithm>(0);
        sets.addAll((Collection<Algorithm>)JWEAlgorithm.Family.AES_GCM_KW);
        sets.addAll((Collection<Algorithm>)JWEAlgorithm.Family.AES_KW);
        sets.addAll((Collection<Algorithm>)JWEAlgorithm.Family.ASYMMETRIC);
        sets.addAll((Collection<Algorithm>)JWEAlgorithm.Family.ECDH_ES);
        sets.addAll((Collection<Algorithm>)JWEAlgorithm.Family.PBES2);
        sets.addAll((Collection<Algorithm>)JWEAlgorithm.Family.RSA);
        sets.addAll((Collection<Algorithm>)JWEAlgorithm.Family.SYMMETRIC);
        String encryptionAlg = this.getRegisteredServiceJwtProperty(service, RegisteredServiceProperty.RegisteredServiceProperties.TOKEN_SECRET_ENCRYPTION_ALG);
        String encryptionSecretAlg = StringUtils.defaultString((String)encryptionAlg, (String)JWEAlgorithm.DIR.getName());
        JWEAlgorithm encAlg = TokenAuthenticationHandler.findAlgorithmFamily(sets, encryptionSecretAlg, JWEAlgorithm.class);
        sets.clear();
        sets.addAll((Collection<Algorithm>)EncryptionMethod.Family.AES_CBC_HMAC_SHA);
        sets.addAll((Collection<Algorithm>)EncryptionMethod.Family.AES_GCM);
        String encryptionMethod = this.getRegisteredServiceJwtProperty(service, RegisteredServiceProperty.RegisteredServiceProperties.TOKEN_SECRET_ENCRYPTION_METHOD);
        String encryptionSecretMethod = StringUtils.defaultString((String)encryptionMethod, (String)EncryptionMethod.A192CBC_HS384.getName());
        EncryptionMethod encMethod = TokenAuthenticationHandler.findAlgorithmFamily(sets, encryptionSecretMethod, EncryptionMethod.class);
        byte[] encSecretBytes = TokenAuthenticationHandler.getSecretBytes(encryptionSecret, this.areSecretsBase64Encoded(service));
        return new SecretEncryptionConfiguration(encSecretBytes, encAlg, encMethod);
    }

    private String getRegisteredServiceJwtEncryptionSecret(RegisteredService service) {
        return this.getRegisteredServiceJwtProperty(service, RegisteredServiceProperty.RegisteredServiceProperties.TOKEN_SECRET_ENCRYPTION);
    }

    private String getRegisteredServiceJwtSigningSecret(RegisteredService service) {
        return this.getRegisteredServiceJwtProperty(service, RegisteredServiceProperty.RegisteredServiceProperties.TOKEN_SECRET_SIGNING);
    }

    private boolean areSecretsBase64Encoded(RegisteredService service) {
        String secretIsBase64String = this.getRegisteredServiceJwtProperty(service, RegisteredServiceProperty.RegisteredServiceProperties.TOKEN_SECRETS_ARE_BASE64_ENCODED);
        return BooleanUtils.toBoolean((String)secretIsBase64String);
    }
}

