/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.token.authentication;

import com.nimbusds.jose.Algorithm;
import com.nimbusds.jose.EncryptionMethod;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.util.Base64;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.AuthenticationHandlerExecutionResult;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.handler.PrincipalNameTransformer;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.integration.pac4j.authentication.handler.support.AbstractTokenWrapperAuthenticationHandler;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceProperty;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.services.UnauthorizedServiceException;
import org.apereo.cas.token.authentication.TokenCredential;
import org.pac4j.core.credentials.TokenCredentials;
import org.pac4j.core.credentials.authenticator.Authenticator;
import org.pac4j.jwt.config.encryption.EncryptionConfiguration;
import org.pac4j.jwt.config.encryption.SecretEncryptionConfiguration;
import org.pac4j.jwt.config.signature.SecretSignatureConfiguration;
import org.pac4j.jwt.config.signature.SignatureConfiguration;
import org.pac4j.jwt.credentials.authenticator.JwtAuthenticator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenAuthenticationHandler
extends AbstractTokenWrapperAuthenticationHandler {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(TokenAuthenticationHandler.class);

    public TokenAuthenticationHandler(String name, ServicesManager servicesManager, PrincipalFactory principalFactory, PrincipalNameTransformer principalNameTransformer) {
        super(name, servicesManager, principalFactory, null, principalNameTransformer);
    }

    private static <T extends Algorithm> T findAlgorithmFamily(Set<Algorithm> family, String alg, Class<T> clazz) {
        Algorithm result = family.stream().filter(l -> l.getName().equalsIgnoreCase(alg)).findFirst().get();
        if (!clazz.isAssignableFrom(result.getClass())) {
            throw new ClassCastException("Result [" + result + " is of type " + result.getClass() + " when we were expecting " + clazz);
        }
        return (T)result;
    }

    public AuthenticationHandlerExecutionResult postAuthenticate(Credential credential, AuthenticationHandlerExecutionResult result) {
        TokenCredential tokenCredential = (TokenCredential)credential;
        tokenCredential.setId(result.getPrincipal().getId());
        return super.postAuthenticate(credential, result);
    }

    protected Authenticator<TokenCredentials> getAuthenticator(Credential credential) {
        TokenCredential tokenCredential = (TokenCredential)credential;
        LOGGER.debug("Locating token secret for service [{}]", (Object)tokenCredential.getService());
        RegisteredService service = this.servicesManager.findServiceBy(tokenCredential.getService());
        String signingSecret = this.getRegisteredServiceJwtSigningSecret(service);
        String encryptionSecret = this.getRegisteredServiceJwtEncryptionSecret(service);
        String serviceSigningAlg = this.getRegisteredServiceJwtProperty(service, RegisteredServiceProperty.RegisteredServiceProperties.TOKEN_SECRET_SIGNING_ALG);
        String signingSecretAlg = StringUtils.defaultString((String)serviceSigningAlg, (String)JWSAlgorithm.HS256.getName());
        String encryptionAlg = this.getRegisteredServiceJwtProperty(service, RegisteredServiceProperty.RegisteredServiceProperties.TOKEN_SECRET_ENCRYPTION_ALG);
        String encryptionSecretAlg = StringUtils.defaultString((String)encryptionAlg, (String)JWEAlgorithm.DIR.getName());
        String encryptionMethod = this.getRegisteredServiceJwtProperty(service, RegisteredServiceProperty.RegisteredServiceProperties.TOKEN_SECRET_ENCRYPTION_METHOD);
        String encryptionSecretMethod = StringUtils.defaultString((String)encryptionMethod, (String)EncryptionMethod.A192CBC_HS384.getName());
        String secretIsBase64String = this.getRegisteredServiceJwtProperty(service, RegisteredServiceProperty.RegisteredServiceProperties.TOKEN_SECRETS_ARE_BASE64_ENCODED);
        boolean secretsAreBase64Encoded = BooleanUtils.toBoolean((String)secretIsBase64String);
        if (StringUtils.isNotBlank((CharSequence)signingSecret)) {
            HashSet<Object> sets = new HashSet<Algorithm>();
            sets.addAll((Collection<Object>)JWSAlgorithm.Family.EC);
            sets.addAll((Collection<Object>)JWSAlgorithm.Family.HMAC_SHA);
            sets.addAll((Collection<Object>)JWSAlgorithm.Family.RSA);
            sets.addAll((Collection<Object>)JWSAlgorithm.Family.SIGNATURE);
            JWSAlgorithm signingAlg = TokenAuthenticationHandler.findAlgorithmFamily(sets, signingSecretAlg, JWSAlgorithm.class);
            JwtAuthenticator jwtAuthenticator = new JwtAuthenticator();
            byte[] secretBytes = TokenAuthenticationHandler.getSecretBytes(signingSecret, secretsAreBase64Encoded);
            jwtAuthenticator.setSignatureConfiguration((SignatureConfiguration)new SecretSignatureConfiguration(secretBytes, signingAlg));
            if (StringUtils.isNotBlank((CharSequence)encryptionSecret)) {
                sets = new HashSet();
                sets.addAll((Collection<Algorithm>)JWEAlgorithm.Family.AES_GCM_KW);
                sets.addAll((Collection<Object>)JWEAlgorithm.Family.AES_KW);
                sets.addAll((Collection<Object>)JWEAlgorithm.Family.ASYMMETRIC);
                sets.addAll((Collection<Object>)JWEAlgorithm.Family.ECDH_ES);
                sets.addAll((Collection<Object>)JWEAlgorithm.Family.PBES2);
                sets.addAll((Collection<Object>)JWEAlgorithm.Family.RSA);
                sets.addAll((Collection<Object>)JWEAlgorithm.Family.SYMMETRIC);
                JWEAlgorithm encAlg = TokenAuthenticationHandler.findAlgorithmFamily(sets, encryptionSecretAlg, JWEAlgorithm.class);
                sets = new HashSet();
                sets.addAll((Collection<Algorithm>)EncryptionMethod.Family.AES_CBC_HMAC_SHA);
                sets.addAll((Collection<Object>)EncryptionMethod.Family.AES_GCM);
                EncryptionMethod encMethod = TokenAuthenticationHandler.findAlgorithmFamily(sets, encryptionSecretMethod, EncryptionMethod.class);
                byte[] encSecretBytes = TokenAuthenticationHandler.getSecretBytes(encryptionSecret, secretsAreBase64Encoded);
                jwtAuthenticator.setEncryptionConfiguration((EncryptionConfiguration)new SecretEncryptionConfiguration(encSecretBytes, encAlg, encMethod));
            } else {
                LOGGER.warn("JWT authentication is configured to share jwtAuthenticator single key for both signing/encryption");
            }
            return jwtAuthenticator;
        }
        LOGGER.warn("No token signing secret is defined for service [{}]. Ensure [{}] property is defined for service", (Object)service.getServiceId(), (Object)RegisteredServiceProperty.RegisteredServiceProperties.TOKEN_SECRET_SIGNING.getPropertyName());
        return null;
    }

    private String getRegisteredServiceJwtEncryptionSecret(RegisteredService service) {
        return this.getRegisteredServiceJwtProperty(service, RegisteredServiceProperty.RegisteredServiceProperties.TOKEN_SECRET_ENCRYPTION);
    }

    private String getRegisteredServiceJwtSigningSecret(RegisteredService service) {
        return this.getRegisteredServiceJwtProperty(service, RegisteredServiceProperty.RegisteredServiceProperties.TOKEN_SECRET_SIGNING);
    }

    protected String getRegisteredServiceJwtProperty(RegisteredService service, RegisteredServiceProperty.RegisteredServiceProperties propName) {
        if (service == null || !service.getAccessStrategy().isServiceAccessAllowed()) {
            LOGGER.debug("Service is not defined/found or its access is disabled in the registry");
            throw new UnauthorizedServiceException("screen.service.error.message");
        }
        if (propName.isAssignedTo(service)) {
            return propName.getPropertyValue(service).getValue();
        }
        LOGGER.warn("Service [{}] does not define a property [{}] in the registry", (Object)service.getServiceId(), (Object)propName);
        return null;
    }

    private static byte[] getSecretBytes(String secret, boolean secretIsBase64Encoded) {
        return secretIsBase64Encoded ? new Base64(secret).decode() : secret.getBytes(StandardCharsets.UTF_8);
    }
}

