/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.token.authentication;

import com.nimbusds.jose.Algorithm;
import com.nimbusds.jose.EncryptionMethod;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.JWSAlgorithm;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.HandlerResult;
import org.apereo.cas.authentication.handler.PrincipalNameTransformer;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.integration.pac4j.authentication.handler.support.AbstractTokenWrapperAuthenticationHandler;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceProperty;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.services.UnauthorizedServiceException;
import org.apereo.cas.token.authentication.TokenCredential;
import org.pac4j.core.credentials.TokenCredentials;
import org.pac4j.core.credentials.authenticator.Authenticator;
import org.pac4j.jwt.config.encryption.EncryptionConfiguration;
import org.pac4j.jwt.config.encryption.SecretEncryptionConfiguration;
import org.pac4j.jwt.config.signature.SecretSignatureConfiguration;
import org.pac4j.jwt.config.signature.SignatureConfiguration;
import org.pac4j.jwt.credentials.authenticator.JwtAuthenticator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenAuthenticationHandler
extends AbstractTokenWrapperAuthenticationHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(TokenAuthenticationHandler.class);

    public TokenAuthenticationHandler(String name, ServicesManager servicesManager, PrincipalFactory principalFactory, PrincipalNameTransformer principalNameTransformer) {
        super(name, servicesManager, principalFactory, null, principalNameTransformer);
    }

    public HandlerResult postAuthenticate(Credential credential, HandlerResult result) {
        TokenCredential tokenCredential = (TokenCredential)credential;
        tokenCredential.setId(result.getPrincipal().getId());
        return super.postAuthenticate(credential, result);
    }

    protected Authenticator<TokenCredentials> getAuthenticator(Credential credential) {
        TokenCredential tokenCredential = (TokenCredential)credential;
        LOGGER.debug("Locating token secret for service [{}]", (Object)tokenCredential.getService());
        RegisteredService service = this.servicesManager.findServiceBy(tokenCredential.getService());
        String signingSecret = this.getRegisteredServiceJwtSigningSecret(service);
        String encryptionSecret = this.getRegisteredServiceJwtEncryptionSecret(service);
        String signingSecretAlg = StringUtils.defaultString((String)this.getRegisteredServiceJwtSecret(service, "jwtSigningSecretAlg"), (String)JWSAlgorithm.HS256.getName());
        String encryptionSecretAlg = StringUtils.defaultString((String)this.getRegisteredServiceJwtSecret(service, "jwtEncryptionSecretAlg"), (String)JWEAlgorithm.DIR.getName());
        String encryptionSecretMethod = StringUtils.defaultString((String)this.getRegisteredServiceJwtSecret(service, "jwtEncryptionSecretMethod"), (String)EncryptionMethod.A192CBC_HS384.getName());
        if (StringUtils.isNotBlank((CharSequence)signingSecret)) {
            HashSet<Object> sets = new HashSet<Algorithm>();
            sets.addAll((Collection<Object>)JWSAlgorithm.Family.EC);
            sets.addAll((Collection<Object>)JWSAlgorithm.Family.HMAC_SHA);
            sets.addAll((Collection<Object>)JWSAlgorithm.Family.RSA);
            sets.addAll((Collection<Object>)JWSAlgorithm.Family.SIGNATURE);
            JWSAlgorithm signingAlg = (JWSAlgorithm)TokenAuthenticationHandler.findAlgorithmFamily(sets, signingSecretAlg);
            JwtAuthenticator a = new JwtAuthenticator();
            a.setSignatureConfiguration((SignatureConfiguration)new SecretSignatureConfiguration(signingSecret, signingAlg));
            if (StringUtils.isNotBlank((CharSequence)encryptionSecret)) {
                sets = new HashSet();
                sets.addAll((Collection<Algorithm>)JWEAlgorithm.Family.AES_GCM_KW);
                sets.addAll((Collection<Object>)JWEAlgorithm.Family.AES_KW);
                sets.addAll((Collection<Object>)JWEAlgorithm.Family.ASYMMETRIC);
                sets.addAll((Collection<Object>)JWEAlgorithm.Family.ECDH_ES);
                sets.addAll((Collection<Object>)JWEAlgorithm.Family.PBES2);
                sets.addAll((Collection<Object>)JWEAlgorithm.Family.RSA);
                sets.addAll((Collection<Object>)JWEAlgorithm.Family.SYMMETRIC);
                JWEAlgorithm encAlg = (JWEAlgorithm)TokenAuthenticationHandler.findAlgorithmFamily(sets, encryptionSecretAlg);
                sets = new HashSet();
                sets.addAll((Collection<Algorithm>)EncryptionMethod.Family.AES_CBC_HMAC_SHA);
                sets.addAll((Collection<Object>)EncryptionMethod.Family.AES_GCM);
                EncryptionMethod encMethod = (EncryptionMethod)TokenAuthenticationHandler.findAlgorithmFamily(sets, encryptionSecretMethod);
                a.setEncryptionConfiguration((EncryptionConfiguration)new SecretEncryptionConfiguration(encryptionSecret, encAlg, encMethod));
            } else {
                LOGGER.warn("JWT authentication is configured to share a single key for both signing/encryption");
            }
            return a;
        }
        LOGGER.warn("No token signing secret is defined for service [{}]. Ensure [{}] property is defined for service", (Object)service.getServiceId(), (Object)"jwtSigningSecret");
        return null;
    }

    private static <T extends Algorithm> T findAlgorithmFamily(Set<Algorithm> family, String alg) {
        return (T)family.stream().filter(l -> l.getName().equalsIgnoreCase(alg)).findFirst().get();
    }

    private String getRegisteredServiceJwtEncryptionSecret(RegisteredService service) {
        return this.getRegisteredServiceJwtSecret(service, "jwtEncryptionSecret");
    }

    private String getRegisteredServiceJwtSigningSecret(RegisteredService service) {
        return this.getRegisteredServiceJwtSecret(service, "jwtSigningSecret");
    }

    protected String getRegisteredServiceJwtSecret(RegisteredService service, String propName) {
        RegisteredServiceProperty propSigning;
        String tokenSigningSecret;
        if (service == null || !service.getAccessStrategy().isServiceAccessAllowed()) {
            LOGGER.debug("Service is not defined/found or its access is disabled in the registry");
            throw new UnauthorizedServiceException("screen.service.error.message");
        }
        if (service.getProperties().containsKey(propName) && StringUtils.isNotBlank((CharSequence)(tokenSigningSecret = (propSigning = (RegisteredServiceProperty)service.getProperties().get(propName)).getValue()))) {
            LOGGER.debug("Found the secret value [{}] for service [{}]", (Object)propName, (Object)service.getServiceId());
            return tokenSigningSecret;
        }
        LOGGER.warn("Service [{}] does not define a property [{}] in the registry", (Object)service.getServiceId(), (Object)propName);
        return null;
    }
}

