/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import org.apereo.cas.authentication.AuthenticationEventExecutionPlan;
import org.apereo.cas.authentication.AuthenticationEventExecutionPlanConfigurer;
import org.apereo.cas.authentication.AuthenticationHandler;
import org.apereo.cas.authentication.principal.DefaultPrincipalFactory;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.PrincipalResolver;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.core.authentication.PrincipalTransformationProperties;
import org.apereo.cas.configuration.model.support.token.TokenAuthenticationProperties;
import org.apereo.cas.configuration.support.Beans;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.token.authentication.TokenAuthenticationHandler;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(value="tokenAuthenticationConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class TokenAuthenticationConfiguration {
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    @Qualifier(value="servicesManager")
    private ServicesManager servicesManager;

    @ConditionalOnMissingBean(name={"tokenPrincipalFactory"})
    @Bean
    public PrincipalFactory tokenPrincipalFactory() {
        return new DefaultPrincipalFactory();
    }

    @Bean
    public AuthenticationHandler tokenAuthenticationHandler() {
        TokenAuthenticationProperties token = this.casProperties.getAuthn().getToken();
        return new TokenAuthenticationHandler(token.getName(), this.servicesManager, this.tokenPrincipalFactory(), Beans.newPrincipalNameTransformer((PrincipalTransformationProperties)token.getPrincipalTransformation()));
    }

    @Configuration(value="tokenAuthenticationEventExecutionPlanConfiguration")
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public class TokenAuthenticationEventExecutionPlanConfiguration
    implements AuthenticationEventExecutionPlanConfigurer {
        @Autowired
        @Qualifier(value="personDirectoryPrincipalResolver")
        private PrincipalResolver personDirectoryPrincipalResolver;

        public void configureAuthenticationExecutionPlan(AuthenticationEventExecutionPlan plan) {
            plan.registerAuthenticationHandlerWithPrincipalResolver(TokenAuthenticationConfiguration.this.tokenAuthenticationHandler(), this.personDirectoryPrincipalResolver);
        }
    }
}

