/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import nz.net.ultraq.thymeleaf.layoutdialect.LayoutDialect;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.config.CasCoreServicesConfiguration;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.core.web.view.RestfulViewProperties;
import org.apereo.cas.services.web.CasThymeleafLoginFormDirector;
import org.apereo.cas.services.web.CasThymeleafOutputTemplateHandler;
import org.apereo.cas.services.web.CasThymeleafViewResolverConfigurer;
import org.apereo.cas.services.web.ThemeBasedViewResolver;
import org.apereo.cas.services.web.ThemeViewResolver;
import org.apereo.cas.services.web.ThemeViewResolverFactory;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.cas.validation.CasProtocolViewFactory;
import org.apereo.cas.web.flow.CasWebflowExecutionPlan;
import org.apereo.cas.web.view.CasProtocolThymeleafViewFactory;
import org.apereo.cas.web.view.ChainingTemplateViewResolver;
import org.apereo.cas.web.view.RestfulUrlTemplateResolver;
import org.apereo.cas.web.view.ThemeClassLoaderTemplateResolver;
import org.apereo.cas.web.view.ThemeFileTemplateResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.ImportAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.thymeleaf.ThymeleafAutoConfiguration;
import org.springframework.boot.autoconfigure.thymeleaf.ThymeleafProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.OrderComparator;
import org.springframework.util.MimeType;
import org.springframework.util.ResourceUtils;
import org.springframework.web.servlet.ThemeResolver;
import org.springframework.web.servlet.ViewResolver;
import org.thymeleaf.dialect.IDialect;
import org.thymeleaf.dialect.IPostProcessorDialect;
import org.thymeleaf.postprocessor.IPostProcessor;
import org.thymeleaf.postprocessor.PostProcessor;
import org.thymeleaf.spring5.ISpringTemplateEngine;
import org.thymeleaf.spring5.SpringTemplateEngine;
import org.thymeleaf.spring5.view.AbstractThymeleafView;
import org.thymeleaf.spring5.view.ThymeleafViewResolver;
import org.thymeleaf.templatemode.TemplateMode;
import org.thymeleaf.templateresolver.AbstractConfigurableTemplateResolver;
import org.thymeleaf.templateresolver.AbstractTemplateResolver;
import org.thymeleaf.templateresolver.ClassLoaderTemplateResolver;
import org.thymeleaf.templateresolver.FileTemplateResolver;
import org.thymeleaf.templateresolver.ITemplateResolver;

@Configuration(value="casThymeleafConfiguration", proxyBeanMethods=false)
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnClass(value={SpringTemplateEngine.class})
@ImportAutoConfiguration(value={ThymeleafAutoConfiguration.class})
@AutoConfigureAfter(value={CasCoreServicesConfiguration.class})
public class CasThymeleafConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CasThymeleafConfiguration.class);
    private static final int THYMELEAF_VIEW_RESOLVER_ORDER = 0x7FFFFFFA;

    private static String appendCharset(MimeType type, String charset) {
        if (type.getCharset() != null) {
            return type.toString();
        }
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
        parameters.put("charset", charset);
        parameters.putAll(type.getParameters());
        return new MimeType(type, parameters).toString();
    }

    private static void configureTemplateViewResolver(AbstractConfigurableTemplateResolver resolver, ThymeleafProperties thymeleafProperties) {
        resolver.setCacheable(thymeleafProperties.isCache());
        resolver.setCharacterEncoding(thymeleafProperties.getEncoding().name());
        resolver.setCheckExistence(thymeleafProperties.isCheckTemplateLocation());
        resolver.setForceTemplateMode(true);
        resolver.setOrder(Integer.valueOf(0));
        resolver.setSuffix(".html");
        resolver.setTemplateMode(thymeleafProperties.getMode());
    }

    @Bean
    public LayoutDialect layoutDialect() {
        return new LayoutDialect();
    }

    @Bean
    @ConditionalOnMissingBean(name={"chainingTemplateViewResolver"})
    public AbstractTemplateResolver chainingTemplateViewResolver(ThymeleafProperties thymeleafProperties, @Qualifier(value="themeResolver") ThemeResolver themeResolver, CasConfigurationProperties casProperties) {
        ChainingTemplateViewResolver chain = new ChainingTemplateViewResolver();
        RestfulViewProperties rest = casProperties.getView().getRest();
        if (StringUtils.isNotBlank((CharSequence)rest.getUrl())) {
            RestfulUrlTemplateResolver url = new RestfulUrlTemplateResolver(casProperties, themeResolver);
            CasThymeleafConfiguration.configureTemplateViewResolver((AbstractConfigurableTemplateResolver)url, thymeleafProperties);
            chain.addResolver((AbstractTemplateResolver)url);
        }
        List templatePrefixes = casProperties.getView().getTemplatePrefixes();
        templatePrefixes.forEach(prefix -> {
            try {
                String prefixPath = ResourceUtils.getFile((String)prefix).getCanonicalPath();
                String viewPath = StringUtils.appendIfMissing((String)prefixPath, (CharSequence)"/", (CharSequence[])new CharSequence[0]);
                Object theme = prefix.startsWith("classpath:") ? new ThemeClassLoaderTemplateResolver(themeResolver) : new ThemeFileTemplateResolver(casProperties, themeResolver);
                CasThymeleafConfiguration.configureTemplateViewResolver((AbstractConfigurableTemplateResolver)theme, thymeleafProperties);
                theme.setPrefix(viewPath + "themes/%s/");
                chain.addResolver((AbstractTemplateResolver)theme);
                ClassLoaderTemplateResolver template = prefix.startsWith("classpath:") ? new ClassLoaderTemplateResolver() : new FileTemplateResolver();
                CasThymeleafConfiguration.configureTemplateViewResolver((AbstractConfigurableTemplateResolver)template, thymeleafProperties);
                template.setPrefix(viewPath);
                chain.addResolver((AbstractTemplateResolver)template);
            }
            catch (Exception e) {
                LoggingUtils.warn((Logger)LOGGER, (String)String.format("Could not add template prefix '%s' to resolver", prefix), (Throwable)e);
            }
        });
        ThemeClassLoaderTemplateResolver themeCp = new ThemeClassLoaderTemplateResolver(themeResolver);
        CasThymeleafConfiguration.configureTemplateViewResolver((AbstractConfigurableTemplateResolver)themeCp, thymeleafProperties);
        themeCp.setPrefix("templates/%s/");
        chain.addResolver((AbstractTemplateResolver)themeCp);
        ClassLoaderTemplateResolver cpResolver = new ClassLoaderTemplateResolver();
        CasThymeleafConfiguration.configureTemplateViewResolver((AbstractConfigurableTemplateResolver)cpResolver, thymeleafProperties);
        cpResolver.setPrefix("thymeleaf/templates/");
        chain.addResolver((AbstractTemplateResolver)cpResolver);
        chain.initialize();
        return chain;
    }

    @ConditionalOnMissingBean(name={"casPropertiesThymeleafViewResolverConfigurer"})
    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public CasThymeleafViewResolverConfigurer casPropertiesThymeleafViewResolverConfigurer(final CasConfigurationProperties casProperties) {
        return new CasThymeleafViewResolverConfigurer(){

            @Override
            public int getOrder() {
                return 0;
            }

            @Override
            public void configureThymeleafViewResolver(ThymeleafViewResolver thymeleafViewResolver) {
                thymeleafViewResolver.addStaticVariable("cas", (Object)casProperties);
                thymeleafViewResolver.addStaticVariable("casProperties", (Object)casProperties);
            }

            @Override
            public void configureThymeleafView(AbstractThymeleafView thymeleafView) {
                thymeleafView.addStaticVariable("cas", (Object)casProperties);
                thymeleafView.addStaticVariable("casProperties", (Object)casProperties);
            }
        };
    }

    @Configuration(value="ThymeleafViewResolverConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class ThymeleafViewResolverConfiguration {
        @ConditionalOnMissingBean(name={"casProtocolViewFactory"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CasProtocolViewFactory casProtocolViewFactory(SpringTemplateEngine springTemplateEngine, ThymeleafProperties thymeleafProperties) {
            return new CasProtocolThymeleafViewFactory(springTemplateEngine, thymeleafProperties);
        }

        @Bean
        public SpringTemplateEngine templateEngine(ThymeleafProperties thymeleafProperties, ObjectProvider<ITemplateResolver> templateResolvers, ObjectProvider<IDialect> dialects) {
            SpringTemplateEngine engine = new SpringTemplateEngine();
            engine.setEnableSpringELCompiler(thymeleafProperties.isEnableSpringElCompiler());
            engine.setRenderHiddenMarkersBeforeCheckboxes(thymeleafProperties.isRenderHiddenMarkersBeforeCheckboxes());
            templateResolvers.orderedStream().forEach(arg_0 -> ((SpringTemplateEngine)engine).addTemplateResolver(arg_0));
            dialects.orderedStream().forEach(arg_0 -> ((SpringTemplateEngine)engine).addDialect(arg_0));
            return engine;
        }

        @ConditionalOnMissingBean(name={"registeredServiceViewResolver"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public ViewResolver registeredServiceViewResolver(@Qualifier(value="themeResolver") ThemeResolver themeResolver, @Qualifier(value="themeViewResolverFactory") ThemeViewResolverFactory themeViewResolverFactory) {
            ThemeBasedViewResolver resolver = new ThemeBasedViewResolver(themeResolver, themeViewResolverFactory);
            resolver.setOrder(0x7FFFFFF9);
            return resolver;
        }

        @ConditionalOnMissingBean(name={"themeViewResolverFactory"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public ThemeViewResolverFactory themeViewResolverFactory(ThymeleafProperties thymeleafProperties, CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext, @Qualifier(value="thymeleafViewResolver") ThymeleafViewResolver thymeleafViewResolver, List<CasThymeleafViewResolverConfigurer> thymeleafViewResolverConfigurers) {
            ThemeViewResolver.Factory factory = new ThemeViewResolver.Factory((ViewResolver)thymeleafViewResolver, thymeleafProperties, casProperties, thymeleafViewResolverConfigurers);
            factory.setApplicationContext((ApplicationContext)applicationContext);
            return factory;
        }

        @Bean
        public ThymeleafViewResolver thymeleafViewResolver(SpringTemplateEngine springTemplateEngine, final ThymeleafProperties thymeleafProperties, ConfigurableApplicationContext applicationContext, List<CasThymeleafViewResolverConfigurer> thymeleafViewResolverConfigurers) {
            ThymeleafViewResolver resolver = new ThymeleafViewResolver();
            resolver.setProducePartialOutputWhileProcessing(thymeleafProperties.getServlet().isProducePartialOutputWhileProcessing());
            resolver.setCharacterEncoding(thymeleafProperties.getEncoding().name());
            resolver.setApplicationContext((ApplicationContext)applicationContext);
            resolver.setExcludedViewNames(thymeleafProperties.getExcludedViewNames());
            resolver.setOrder(0x7FFFFFFA);
            resolver.setCache(false);
            resolver.setViewNames(thymeleafProperties.getViewNames());
            resolver.setContentType(CasThymeleafConfiguration.appendCharset(thymeleafProperties.getServlet().getContentType(), resolver.getCharacterEncoding()));
            if (!springTemplateEngine.isInitialized()) {
                springTemplateEngine.addDialect((IDialect)new IPostProcessorDialect(){

                    public int getDialectPostProcessorPrecedence() {
                        return Integer.MAX_VALUE;
                    }

                    public Set<IPostProcessor> getPostProcessors() {
                        return CollectionUtils.wrapSet((Object)new PostProcessor(TemplateMode.parse((String)thymeleafProperties.getMode()), CasThymeleafOutputTemplateHandler.class, Integer.MAX_VALUE));
                    }

                    public String getName() {
                        return CasThymeleafOutputTemplateHandler.class.getSimpleName();
                    }
                });
            }
            resolver.setTemplateEngine((ISpringTemplateEngine)springTemplateEngine);
            thymeleafViewResolverConfigurers.stream().sorted(OrderComparator.INSTANCE).forEach(configurer -> configurer.configureThymeleafViewResolver(resolver));
            return resolver;
        }
    }

    @Configuration(value="ThymeleafWebflowConfiguration", proxyBeanMethods=false)
    @ConditionalOnBean(name={"casWebflowExecutionPlan"})
    @DependsOn(value={"casWebflowExecutionPlan"})
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class ThymeleafWebflowConfiguration {
        @ConditionalOnMissingBean(name={"casThymeleafLoginFormDirector"})
        @Bean
        public CasThymeleafLoginFormDirector casThymeleafLoginFormDirector(@Qualifier(value="casWebflowExecutionPlan") CasWebflowExecutionPlan webflowExecutionPlan) {
            return new CasThymeleafLoginFormDirector(webflowExecutionPlan);
        }
    }
}

