/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.view;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpResponse;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.core.web.view.RestfulViewProperties;
import org.apereo.cas.util.HttpRequestUtils;
import org.apereo.cas.util.HttpUtils;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.cas.web.support.WebUtils;
import org.apereo.cas.web.view.ThemeFileTemplateResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.thymeleaf.IEngineConfiguration;
import org.thymeleaf.templateresource.ITemplateResource;
import org.thymeleaf.templateresource.StringTemplateResource;

public class RestfulUrlTemplateResolver
extends ThemeFileTemplateResolver {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(RestfulUrlTemplateResolver.class);

    public RestfulUrlTemplateResolver(CasConfigurationProperties casProperties) {
        super(casProperties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ITemplateResource computeTemplateResource(IEngineConfiguration configuration, String ownerTemplate, String template, String resourceName, String characterEncoding, Map<String, Object> templateResolutionAttributes) {
        HttpServletRequest request;
        RestfulViewProperties rest = this.casProperties.getView().getRest();
        String themeName = this.getCurrentTheme();
        LinkedHashMap<String, String> headers = new LinkedHashMap<String, String>();
        headers.put("owner", ownerTemplate);
        headers.put("template", template);
        headers.put("resource", resourceName);
        if (StringUtils.isNotBlank((CharSequence)themeName)) {
            headers.put("theme", themeName);
        }
        if ((request = WebUtils.getHttpServletRequestFromExternalWebflowContext()) != null) {
            headers.put("locale", request.getLocale().getCountry());
            headers.putAll(HttpRequestUtils.getRequestHeaders((HttpServletRequest)request));
        }
        headers.putAll(rest.getHeaders());
        HttpResponse response = null;
        try {
            HttpUtils.HttpExecutionRequest exec = HttpUtils.HttpExecutionRequest.builder().basicAuthPassword(rest.getBasicAuthPassword()).basicAuthUsername(rest.getBasicAuthUsername()).method(HttpMethod.valueOf((String)rest.getMethod().toUpperCase().trim())).url(rest.getUrl()).headers(headers).build();
            response = HttpUtils.execute((HttpUtils.HttpExecutionRequest)exec);
            int statusCode = response.getStatusLine().getStatusCode();
            if (HttpStatus.valueOf((int)statusCode).is2xxSuccessful()) {
                String result = IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
                StringTemplateResource stringTemplateResource = new StringTemplateResource(result);
                HttpUtils.close((HttpResponse)response);
                return stringTemplateResource;
            }
            HttpUtils.close((HttpResponse)response);
        }
        catch (Exception e) {
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
        }
        finally {
            HttpUtils.close(response);
        }
        return super.computeTemplateResource(configuration, ownerTemplate, template, resourceName, characterEncoding, templateResolutionAttributes);
    }
}

